package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{
  PlatformFilterValue,
  PlatformFilterOperator,
  PlatformFilterType
}
import scala.jdk.CollectionConverters._
final case class PlatformFilter(
    `type`: Option[PlatformFilterType] = None,
    operator: Option[PlatformFilterOperator] = None,
    values: Option[Iterable[PlatformFilterValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFilter = {
    import PlatformFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFilter
      .builder()
      .optionallyWith(
        `type`.map(value => PlatformFilterType.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        operator.map(value =>
          PlatformFilterOperator.unwrap(value): java.lang.String
        )
      )(_.operator)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            PlatformFilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.PlatformFilter.ReadOnly =
    zio.aws.elasticbeanstalk.model.PlatformFilter.wrap(buildAwsValue())
}
object PlatformFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.PlatformFilter =
      zio.aws.elasticbeanstalk.model.PlatformFilter(
        `type`.map(value => value),
        operator.map(value => value),
        values.map(value => value)
      )
    def `type`: Option[PlatformFilterType]
    def operator: Option[PlatformFilterOperator]
    def values: Option[List[PlatformFilterValue]]
    def getType: ZIO[Any, AwsError, PlatformFilterType] =
      AwsError.unwrapOptionField("type", `type`)
    def getOperator: ZIO[Any, AwsError, PlatformFilterOperator] =
      AwsError.unwrapOptionField("operator", operator)
    def getValues: ZIO[Any, AwsError, List[PlatformFilterValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFilter
  ) extends zio.aws.elasticbeanstalk.model.PlatformFilter.ReadOnly {
    override val `type`: Option[PlatformFilterType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformFilterType(value)
      )
    override val operator: Option[PlatformFilterOperator] = scala
      .Option(impl.operator())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformFilterOperator(value)
      )
    override val values: Option[List[PlatformFilterValue]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.primitives.PlatformFilterValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFilter
  ): zio.aws.elasticbeanstalk.model.PlatformFilter.ReadOnly = new Wrapper(impl)
}
