package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class DescribeEnvironmentsResponse(
    environments: Option[
      Iterable[zio.aws.elasticbeanstalk.model.EnvironmentDescription]
    ] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsResponse = {
    import DescribeEnvironmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsResponse
      .builder()
      .optionallyWith(
        environments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environments)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeEnvironmentsResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeEnvironmentsResponse
      .wrap(buildAwsValue())
}
object DescribeEnvironmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DescribeEnvironmentsResponse =
      zio.aws.elasticbeanstalk.model.DescribeEnvironmentsResponse(
        environments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def environments: Option[
      List[zio.aws.elasticbeanstalk.model.EnvironmentDescription.ReadOnly]
    ]
    def nextToken: Option[Token]
    def getEnvironments: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.EnvironmentDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("environments", environments)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsResponse
  ) extends zio.aws.elasticbeanstalk.model.DescribeEnvironmentsResponse.ReadOnly {
    override val environments: Option[
      List[zio.aws.elasticbeanstalk.model.EnvironmentDescription.ReadOnly]
    ] = scala
      .Option(impl.environments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.EnvironmentDescription.wrap(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsResponse
  ): zio.aws.elasticbeanstalk.model.DescribeEnvironmentsResponse.ReadOnly =
    new Wrapper(impl)
}
