package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.elasticbeanstalk.model.primitives.{
  ApplicationVersionArn,
  ApplicationName,
  VersionLabel,
  UpdateDate,
  Description,
  CreationDate
}
import scala.jdk.CollectionConverters._
final case class ApplicationVersionDescription(
    applicationVersionArn: Option[ApplicationVersionArn] = None,
    applicationName: Option[ApplicationName] = None,
    description: Option[Description] = None,
    versionLabel: Option[VersionLabel] = None,
    sourceBuildInformation: Option[
      zio.aws.elasticbeanstalk.model.SourceBuildInformation
    ] = None,
    buildArn: Option[String] = None,
    sourceBundle: Option[zio.aws.elasticbeanstalk.model.S3Location] = None,
    dateCreated: Option[CreationDate] = None,
    dateUpdated: Option[UpdateDate] = None,
    status: Option[zio.aws.elasticbeanstalk.model.ApplicationVersionStatus] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionDescription = {
    import ApplicationVersionDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionDescription
      .builder()
      .optionallyWith(
        applicationVersionArn.map(value =>
          ApplicationVersionArn.unwrap(value): java.lang.String
        )
      )(_.applicationVersionArn)
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        versionLabel.map(value => VersionLabel.unwrap(value): java.lang.String)
      )(_.versionLabel)
      .optionallyWith(
        sourceBuildInformation.map(value => value.buildAwsValue())
      )(_.sourceBuildInformation)
      .optionallyWith(buildArn.map(value => value: java.lang.String))(
        _.buildArn
      )
      .optionallyWith(sourceBundle.map(value => value.buildAwsValue()))(
        _.sourceBundle
      )
      .optionallyWith(
        dateCreated.map(value => CreationDate.unwrap(value): Instant)
      )(_.dateCreated)
      .optionallyWith(
        dateUpdated.map(value => UpdateDate.unwrap(value): Instant)
      )(_.dateUpdated)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ApplicationVersionDescription.ReadOnly =
    zio.aws.elasticbeanstalk.model.ApplicationVersionDescription
      .wrap(buildAwsValue())
}
object ApplicationVersionDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.ApplicationVersionDescription =
      zio.aws.elasticbeanstalk.model.ApplicationVersionDescription(
        applicationVersionArn.map(value => value),
        applicationName.map(value => value),
        description.map(value => value),
        versionLabel.map(value => value),
        sourceBuildInformation.map(value => value.asEditable),
        buildArn.map(value => value),
        sourceBundle.map(value => value.asEditable),
        dateCreated.map(value => value),
        dateUpdated.map(value => value),
        status.map(value => value)
      )
    def applicationVersionArn: Option[ApplicationVersionArn]
    def applicationName: Option[ApplicationName]
    def description: Option[Description]
    def versionLabel: Option[VersionLabel]
    def sourceBuildInformation
        : Option[zio.aws.elasticbeanstalk.model.SourceBuildInformation.ReadOnly]
    def buildArn: Option[String]
    def sourceBundle: Option[zio.aws.elasticbeanstalk.model.S3Location.ReadOnly]
    def dateCreated: Option[CreationDate]
    def dateUpdated: Option[UpdateDate]
    def status: Option[zio.aws.elasticbeanstalk.model.ApplicationVersionStatus]
    def getApplicationVersionArn: ZIO[Any, AwsError, ApplicationVersionArn] =
      AwsError.unwrapOptionField("applicationVersionArn", applicationVersionArn)
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getVersionLabel: ZIO[Any, AwsError, VersionLabel] =
      AwsError.unwrapOptionField("versionLabel", versionLabel)
    def getSourceBuildInformation: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.SourceBuildInformation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sourceBuildInformation",
      sourceBuildInformation
    )
    def getBuildArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("buildArn", buildArn)
    def getSourceBundle: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.S3Location.ReadOnly
    ] = AwsError.unwrapOptionField("sourceBundle", sourceBundle)
    def getDateCreated: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getDateUpdated: ZIO[Any, AwsError, UpdateDate] =
      AwsError.unwrapOptionField("dateUpdated", dateUpdated)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ApplicationVersionStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionDescription
  ) extends zio.aws.elasticbeanstalk.model.ApplicationVersionDescription.ReadOnly {
    override val applicationVersionArn: Option[ApplicationVersionArn] = scala
      .Option(impl.applicationVersionArn())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.ApplicationVersionArn(value)
      )
    override val applicationName: Option[ApplicationName] = scala
      .Option(impl.applicationName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.ApplicationName(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.Description(value)
      )
    override val versionLabel: Option[VersionLabel] = scala
      .Option(impl.versionLabel())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.VersionLabel(value)
      )
    override val sourceBuildInformation: Option[
      zio.aws.elasticbeanstalk.model.SourceBuildInformation.ReadOnly
    ] = scala
      .Option(impl.sourceBuildInformation())
      .map(value =>
        zio.aws.elasticbeanstalk.model.SourceBuildInformation.wrap(value)
      )
    override val buildArn: Option[String] =
      scala.Option(impl.buildArn()).map(value => value: String)
    override val sourceBundle
        : Option[zio.aws.elasticbeanstalk.model.S3Location.ReadOnly] = scala
      .Option(impl.sourceBundle())
      .map(value => zio.aws.elasticbeanstalk.model.S3Location.wrap(value))
    override val dateCreated: Option[CreationDate] = scala
      .Option(impl.dateCreated())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.CreationDate(value)
      )
    override val dateUpdated: Option[UpdateDate] = scala
      .Option(impl.dateUpdated())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.UpdateDate(value))
    override val status
        : Option[zio.aws.elasticbeanstalk.model.ApplicationVersionStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          zio.aws.elasticbeanstalk.model.ApplicationVersionStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionDescription
  ): zio.aws.elasticbeanstalk.model.ApplicationVersionDescription.ReadOnly =
    new Wrapper(impl)
}
