package zio.aws.elasticbeanstalk
import zio.aws.elasticbeanstalk.model.UpdateApplicationResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.elasticbeanstalk.model.{
  UpdateApplicationRequest,
  CreatePlatformVersionRequest,
  DeleteConfigurationTemplateRequest,
  DeleteApplicationRequest,
  AssociateEnvironmentOperationsRoleRequest,
  DeleteApplicationVersionRequest,
  UpdateTagsForResourceRequest,
  DescribeEnvironmentHealthRequest,
  UpdateApplicationVersionRequest,
  RebuildEnvironmentRequest,
  ApplyEnvironmentManagedActionRequest,
  CheckDnsAvailabilityRequest,
  CreateApplicationVersionRequest,
  UpdateConfigurationTemplateRequest,
  UpdateApplicationResourceLifecycleRequest,
  DescribeEventsRequest,
  UpdateEnvironmentRequest,
  DescribeEnvironmentResourcesRequest,
  ListPlatformBranchesRequest,
  RequestEnvironmentInfoRequest,
  CreateApplicationRequest,
  ListTagsForResourceRequest,
  RetrieveEnvironmentInfoRequest,
  SwapEnvironmentCnamEsRequest,
  DescribeEnvironmentsRequest,
  DeletePlatformVersionRequest,
  DescribeApplicationsRequest,
  DescribeInstancesHealthRequest,
  ComposeEnvironmentsRequest,
  DescribeConfigurationSettingsRequest,
  DescribeApplicationVersionsRequest,
  ListPlatformVersionsRequest,
  DisassociateEnvironmentOperationsRoleRequest,
  DescribePlatformVersionRequest,
  CreateConfigurationTemplateRequest,
  DescribeConfigurationOptionsRequest,
  DeleteEnvironmentConfigurationRequest,
  DescribeEnvironmentManagedActionHistoryRequest,
  TerminateEnvironmentRequest,
  RestartAppServerRequest,
  CreateEnvironmentRequest,
  ValidateConfigurationSettingsRequest,
  DescribeEnvironmentManagedActionsRequest,
  AbortEnvironmentUpdateRequest
}
import software.amazon.awssdk.services.elasticbeanstalk.model.{
  ComposeEnvironmentsResponse,
  CreateApplicationVersionResponse,
  ListPlatformBranchesResponse,
  DescribeEnvironmentManagedActionHistoryResponse,
  DescribeEnvironmentResourcesResponse,
  DescribeEventsResponse,
  EnvironmentDescription,
  DeleteApplicationVersionResponse,
  AssociateEnvironmentOperationsRoleResponse,
  ApplicationVersionDescription,
  UpdateTagsForResourceResponse,
  DescribeEnvironmentManagedActionsResponse,
  DescribePlatformVersionResponse,
  RestartAppServerResponse,
  DeleteEnvironmentConfigurationResponse,
  UpdateConfigurationTemplateResponse,
  PlatformBranchSummary,
  SwapEnvironmentCnamEsResponse,
  CreateStorageLocationResponse,
  UpdateApplicationResponse,
  ListAvailableSolutionStacksRequest,
  DescribeEnvironmentsResponse,
  CheckDnsAvailabilityResponse,
  CreateConfigurationTemplateResponse,
  DescribeInstancesHealthResponse,
  DeleteConfigurationTemplateResponse,
  UpdateApplicationVersionResponse,
  UpdateEnvironmentResponse,
  ListTagsForResourceResponse,
  DescribeApplicationVersionsResponse,
  AbortEnvironmentUpdateResponse,
  UpdateApplicationResourceLifecycleResponse,
  ApplyEnvironmentManagedActionResponse,
  ValidateConfigurationSettingsResponse,
  PlatformSummary,
  CreateApplicationResponse,
  DeletePlatformVersionResponse,
  DescribeConfigurationOptionsResponse,
  CreateStorageLocationRequest,
  DisassociateEnvironmentOperationsRoleResponse,
  DescribeConfigurationSettingsResponse,
  DescribeAccountAttributesRequest,
  RetrieveEnvironmentInfoResponse,
  ListPlatformVersionsResponse,
  SingleInstanceHealth,
  RebuildEnvironmentResponse,
  DescribeApplicationsResponse,
  ManagedActionHistoryItem,
  ListAvailableSolutionStacksResponse,
  EventDescription,
  DescribeAccountAttributesResponse,
  RequestEnvironmentInfoResponse,
  CreateEnvironmentResponse,
  DeleteApplicationResponse,
  TerminateEnvironmentResponse,
  CreatePlatformVersionResponse,
  DescribeEnvironmentHealthResponse
}
import software.amazon.awssdk.services.elasticbeanstalk.{
  ElasticBeanstalkAsyncClientBuilder,
  ElasticBeanstalkAsyncClient
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait ElasticBeanstalk extends AspectSupport[ElasticBeanstalk] {
  val api: ElasticBeanstalkAsyncClient
  def describeConfigurationOptions(
      request: DescribeConfigurationOptionsRequest
  ): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.DescribeConfigurationOptionsResponse.ReadOnly
  ]
  def createPlatformVersion(request: CreatePlatformVersionRequest): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.CreatePlatformVersionResponse.ReadOnly
  ]
  def deleteApplication(request: DeleteApplicationRequest): IO[AwsError, Unit]
  def listPlatformVersions(request: ListPlatformVersionsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.elasticbeanstalk.model.PlatformSummary.ReadOnly
  ]
  def listPlatformVersionsPaginated(request: ListPlatformVersionsRequest): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.ListPlatformVersionsResponse.ReadOnly
  ]
  def checkDNSAvailability(request: CheckDnsAvailabilityRequest): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.CheckDnsAvailabilityResponse.ReadOnly
  ]
  def validateConfigurationSettings(
      request: ValidateConfigurationSettingsRequest
  ): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.ValidateConfigurationSettingsResponse.ReadOnly
  ]
  def retrieveEnvironmentInfo(request: RetrieveEnvironmentInfoRequest): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.RetrieveEnvironmentInfoResponse.ReadOnly
  ]
  def describePlatformVersion(request: DescribePlatformVersionRequest): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.DescribePlatformVersionResponse.ReadOnly
  ]
  def updateTagsForResource(
      request: UpdateTagsForResourceRequest
  ): IO[AwsError, Unit]
  def deleteApplicationVersion(
      request: DeleteApplicationVersionRequest
  ): IO[AwsError, Unit]
  def listPlatformBranches(request: ListPlatformBranchesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.elasticbeanstalk.model.PlatformBranchSummary.ReadOnly
  ]
  def listPlatformBranchesPaginated(request: ListPlatformBranchesRequest): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.ListPlatformBranchesResponse.ReadOnly
  ]
  def createApplicationVersion(request: CreateApplicationVersionRequest): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.CreateApplicationVersionResponse.ReadOnly
  ]
  def createEnvironment(request: CreateEnvironmentRequest): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.CreateEnvironmentResponse.ReadOnly
  ]
  def deleteConfigurationTemplate(
      request: DeleteConfigurationTemplateRequest
  ): IO[AwsError, Unit]
  def createApplication(request: CreateApplicationRequest): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.CreateApplicationResponse.ReadOnly
  ]
  def createConfigurationTemplate(
      request: CreateConfigurationTemplateRequest
  ): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.CreateConfigurationTemplateResponse.ReadOnly
  ]
  def describeEnvironmentManagedActions(
      request: DescribeEnvironmentManagedActionsRequest
  ): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionsResponse.ReadOnly
  ]
  def describeEnvironmentResources(
      request: DescribeEnvironmentResourcesRequest
  ): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.DescribeEnvironmentResourcesResponse.ReadOnly
  ]
  def createStorageLocation(): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.CreateStorageLocationResponse.ReadOnly
  ]
  def deleteEnvironmentConfiguration(
      request: DeleteEnvironmentConfigurationRequest
  ): IO[AwsError, Unit]
  def abortEnvironmentUpdate(
      request: AbortEnvironmentUpdateRequest
  ): IO[AwsError, Unit]
  def swapEnvironmentCNAMEs(
      request: SwapEnvironmentCnamEsRequest
  ): IO[AwsError, Unit]
  def describeConfigurationSettings(
      request: DescribeConfigurationSettingsRequest
  ): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.DescribeConfigurationSettingsResponse.ReadOnly
  ]
  def listAvailableSolutionStacks(): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.ListAvailableSolutionStacksResponse.ReadOnly
  ]
  def restartAppServer(request: RestartAppServerRequest): IO[AwsError, Unit]
  def composeEnvironments(request: ComposeEnvironmentsRequest): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.ComposeEnvironmentsResponse.ReadOnly
  ]
  def disassociateEnvironmentOperationsRole(
      request: DisassociateEnvironmentOperationsRoleRequest
  ): IO[AwsError, Unit]
  def describeApplicationVersions(
      request: DescribeApplicationVersionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.elasticbeanstalk.model.ApplicationVersionDescription.ReadOnly
  ]
  def describeApplicationVersionsPaginated(
      request: DescribeApplicationVersionsRequest
  ): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.DescribeApplicationVersionsResponse.ReadOnly
  ]
  def associateEnvironmentOperationsRole(
      request: AssociateEnvironmentOperationsRoleRequest
  ): IO[AwsError, Unit]
  def updateApplicationResourceLifecycle(
      request: UpdateApplicationResourceLifecycleRequest
  ): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.UpdateApplicationResourceLifecycleResponse.ReadOnly
  ]
  def requestEnvironmentInfo(
      request: RequestEnvironmentInfoRequest
  ): IO[AwsError, Unit]
  def rebuildEnvironment(request: RebuildEnvironmentRequest): IO[AwsError, Unit]
  def describeEnvironments(request: DescribeEnvironmentsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.elasticbeanstalk.model.EnvironmentDescription.ReadOnly
  ]
  def describeEnvironmentsPaginated(request: DescribeEnvironmentsRequest): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.DescribeEnvironmentsResponse.ReadOnly
  ]
  def applyEnvironmentManagedAction(
      request: ApplyEnvironmentManagedActionRequest
  ): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse.ReadOnly
  ]
  def describeApplications(request: DescribeApplicationsRequest): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.DescribeApplicationsResponse.ReadOnly
  ]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.ListTagsForResourceResponse.ReadOnly
  ]
  def updateEnvironment(request: UpdateEnvironmentRequest): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.UpdateEnvironmentResponse.ReadOnly
  ]
  def describeInstancesHealth(
      request: DescribeInstancesHealthRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.elasticbeanstalk.model.DescribeInstancesHealthResponse.ReadOnly,
    zio.aws.elasticbeanstalk.model.SingleInstanceHealth.ReadOnly
  ]]
  def describeInstancesHealthPaginated(
      request: DescribeInstancesHealthRequest
  ): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.DescribeInstancesHealthResponse.ReadOnly
  ]
  def updateApplicationVersion(request: UpdateApplicationVersionRequest): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.UpdateApplicationVersionResponse.ReadOnly
  ]
  def terminateEnvironment(request: TerminateEnvironmentRequest): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.TerminateEnvironmentResponse.ReadOnly
  ]
  def updateApplication(
      request: UpdateApplicationRequest
  ): IO[AwsError, ReadOnly]
  def deletePlatformVersion(request: DeletePlatformVersionRequest): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.DeletePlatformVersionResponse.ReadOnly
  ]
  def describeEnvironmentManagedActionHistory(
      request: DescribeEnvironmentManagedActionHistoryRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.elasticbeanstalk.model.ManagedActionHistoryItem.ReadOnly
  ]
  def describeEnvironmentManagedActionHistoryPaginated(
      request: DescribeEnvironmentManagedActionHistoryRequest
  ): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse.ReadOnly
  ]
  def describeAccountAttributes(): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.DescribeAccountAttributesResponse.ReadOnly
  ]
  def updateConfigurationTemplate(
      request: UpdateConfigurationTemplateRequest
  ): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.UpdateConfigurationTemplateResponse.ReadOnly
  ]
  def describeEnvironmentHealth(request: DescribeEnvironmentHealthRequest): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.DescribeEnvironmentHealthResponse.ReadOnly
  ]
  def describeEvents(request: DescribeEventsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.elasticbeanstalk.model.EventDescription.ReadOnly
  ]
  def describeEventsPaginated(request: DescribeEventsRequest): IO[
    AwsError,
    zio.aws.elasticbeanstalk.model.DescribeEventsResponse.ReadOnly
  ]
}
object ElasticBeanstalk {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ElasticBeanstalk] =
    customized(identity)
  def customized(
      customization: ElasticBeanstalkAsyncClientBuilder => ElasticBeanstalkAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ElasticBeanstalk] = managed(
    customization
  ).toLayer
  def managed(
      customization: ElasticBeanstalkAsyncClientBuilder => ElasticBeanstalkAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, ElasticBeanstalk] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = ElasticBeanstalkAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[
        ElasticBeanstalkAsyncClient,
        ElasticBeanstalkAsyncClientBuilder
      ](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        ElasticBeanstalkAsyncClient,
        ElasticBeanstalkAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new ElasticBeanstalkImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ElasticBeanstalkImpl[R](
      override val api: ElasticBeanstalkAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ElasticBeanstalk
      with AwsServiceBase[R] {
    override val serviceName: String = "ElasticBeanstalk"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ElasticBeanstalkImpl[R1] = new ElasticBeanstalkImpl(api, newAspect, r)
    def describeConfigurationOptions(
        request: DescribeConfigurationOptionsRequest
    ): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.DescribeConfigurationOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest,
      DescribeConfigurationOptionsResponse
    ]("describeConfigurationOptions", api.describeConfigurationOptions)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticbeanstalk.model.DescribeConfigurationOptionsResponse.wrap
    ).provideEnvironment(r)
    def createPlatformVersion(request: CreatePlatformVersionRequest): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.CreatePlatformVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.CreatePlatformVersionRequest,
      CreatePlatformVersionResponse
    ]("createPlatformVersion", api.createPlatformVersion)(
      request.buildAwsValue()
    ).map(zio.aws.elasticbeanstalk.model.CreatePlatformVersionResponse.wrap)
      .provideEnvironment(r)
    def deleteApplication(
        request: DeleteApplicationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationRequest,
      DeleteApplicationResponse
    ]("deleteApplication", api.deleteApplication)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def listPlatformVersions(request: ListPlatformVersionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.PlatformSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest,
      ListPlatformVersionsResponse,
      PlatformSummary
    ](
      "listPlatformVersions",
      api.listPlatformVersions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.platformSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.elasticbeanstalk.model.PlatformSummary.wrap(item))
      .provideEnvironment(r)
    def listPlatformVersionsPaginated(request: ListPlatformVersionsRequest): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.ListPlatformVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest,
      ListPlatformVersionsResponse
    ]("listPlatformVersions", api.listPlatformVersions)(request.buildAwsValue())
      .map(zio.aws.elasticbeanstalk.model.ListPlatformVersionsResponse.wrap)
      .provideEnvironment(r)
    def checkDNSAvailability(request: CheckDnsAvailabilityRequest): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.CheckDnsAvailabilityResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.CheckDnsAvailabilityRequest,
      CheckDnsAvailabilityResponse
    ]("checkDNSAvailability", api.checkDNSAvailability)(request.buildAwsValue())
      .map(zio.aws.elasticbeanstalk.model.CheckDnsAvailabilityResponse.wrap)
      .provideEnvironment(r)
    def validateConfigurationSettings(
        request: ValidateConfigurationSettingsRequest
    ): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.ValidateConfigurationSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest,
      ValidateConfigurationSettingsResponse
    ]("validateConfigurationSettings", api.validateConfigurationSettings)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticbeanstalk.model.ValidateConfigurationSettingsResponse.wrap
    ).provideEnvironment(r)
    def retrieveEnvironmentInfo(request: RetrieveEnvironmentInfoRequest): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.RetrieveEnvironmentInfoResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest,
      RetrieveEnvironmentInfoResponse
    ]("retrieveEnvironmentInfo", api.retrieveEnvironmentInfo)(
      request.buildAwsValue()
    ).map(zio.aws.elasticbeanstalk.model.RetrieveEnvironmentInfoResponse.wrap)
      .provideEnvironment(r)
    def describePlatformVersion(request: DescribePlatformVersionRequest): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.DescribePlatformVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.DescribePlatformVersionRequest,
      DescribePlatformVersionResponse
    ]("describePlatformVersion", api.describePlatformVersion)(
      request.buildAwsValue()
    ).map(zio.aws.elasticbeanstalk.model.DescribePlatformVersionResponse.wrap)
      .provideEnvironment(r)
    def updateTagsForResource(
        request: UpdateTagsForResourceRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.UpdateTagsForResourceRequest,
      UpdateTagsForResourceResponse
    ]("updateTagsForResource", api.updateTagsForResource)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteApplicationVersion(
        request: DeleteApplicationVersionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationVersionRequest,
      DeleteApplicationVersionResponse
    ]("deleteApplicationVersion", api.deleteApplicationVersion)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listPlatformBranches(request: ListPlatformBranchesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.PlatformBranchSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest,
      ListPlatformBranchesResponse,
      PlatformBranchSummary
    ](
      "listPlatformBranches",
      api.listPlatformBranches,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.platformBranchSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.elasticbeanstalk.model.PlatformBranchSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listPlatformBranchesPaginated(request: ListPlatformBranchesRequest): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.ListPlatformBranchesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest,
      ListPlatformBranchesResponse
    ]("listPlatformBranches", api.listPlatformBranches)(request.buildAwsValue())
      .map(zio.aws.elasticbeanstalk.model.ListPlatformBranchesResponse.wrap)
      .provideEnvironment(r)
    def createApplicationVersion(request: CreateApplicationVersionRequest): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.CreateApplicationVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionRequest,
      CreateApplicationVersionResponse
    ]("createApplicationVersion", api.createApplicationVersion)(
      request.buildAwsValue()
    ).map(zio.aws.elasticbeanstalk.model.CreateApplicationVersionResponse.wrap)
      .provideEnvironment(r)
    def createEnvironment(request: CreateEnvironmentRequest): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.CreateEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.CreateEnvironmentRequest,
      CreateEnvironmentResponse
    ]("createEnvironment", api.createEnvironment)(request.buildAwsValue())
      .map(zio.aws.elasticbeanstalk.model.CreateEnvironmentResponse.wrap)
      .provideEnvironment(r)
    def deleteConfigurationTemplate(
        request: DeleteConfigurationTemplateRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest,
      DeleteConfigurationTemplateResponse
    ]("deleteConfigurationTemplate", api.deleteConfigurationTemplate)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createApplication(request: CreateApplicationRequest): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.CreateApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationRequest,
      CreateApplicationResponse
    ]("createApplication", api.createApplication)(request.buildAwsValue())
      .map(zio.aws.elasticbeanstalk.model.CreateApplicationResponse.wrap)
      .provideEnvironment(r)
    def createConfigurationTemplate(
        request: CreateConfigurationTemplateRequest
    ): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.CreateConfigurationTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest,
      CreateConfigurationTemplateResponse
    ]("createConfigurationTemplate", api.createConfigurationTemplate)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticbeanstalk.model.CreateConfigurationTemplateResponse.wrap
    ).provideEnvironment(r)
    def describeEnvironmentManagedActions(
        request: DescribeEnvironmentManagedActionsRequest
    ): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest,
      DescribeEnvironmentManagedActionsResponse
    ](
      "describeEnvironmentManagedActions",
      api.describeEnvironmentManagedActions
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionsResponse.wrap
      )
      .provideEnvironment(r)
    def describeEnvironmentResources(
        request: DescribeEnvironmentResourcesRequest
    ): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.DescribeEnvironmentResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest,
      DescribeEnvironmentResourcesResponse
    ]("describeEnvironmentResources", api.describeEnvironmentResources)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticbeanstalk.model.DescribeEnvironmentResourcesResponse.wrap
    ).provideEnvironment(r)
    def createStorageLocation(): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.CreateStorageLocationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateStorageLocationRequest,
      CreateStorageLocationResponse
    ]("createStorageLocation", api.createStorageLocation)(
      CreateStorageLocationRequest.builder().build()
    ).map(zio.aws.elasticbeanstalk.model.CreateStorageLocationResponse.wrap)
      .provideEnvironment(r)
    def deleteEnvironmentConfiguration(
        request: DeleteEnvironmentConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest,
      DeleteEnvironmentConfigurationResponse
    ]("deleteEnvironmentConfiguration", api.deleteEnvironmentConfiguration)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def abortEnvironmentUpdate(
        request: AbortEnvironmentUpdateRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest,
      AbortEnvironmentUpdateResponse
    ]("abortEnvironmentUpdate", api.abortEnvironmentUpdate)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def swapEnvironmentCNAMEs(
        request: SwapEnvironmentCnamEsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.SwapEnvironmentCnamEsRequest,
      SwapEnvironmentCnamEsResponse
    ]("swapEnvironmentCNAMEs", api.swapEnvironmentCNAMEs)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeConfigurationSettings(
        request: DescribeConfigurationSettingsRequest
    ): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.DescribeConfigurationSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest,
      DescribeConfigurationSettingsResponse
    ]("describeConfigurationSettings", api.describeConfigurationSettings)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticbeanstalk.model.DescribeConfigurationSettingsResponse.wrap
    ).provideEnvironment(r)
    def listAvailableSolutionStacks(): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.ListAvailableSolutionStacksResponse.ReadOnly
    ] = asyncRequestResponse[
      ListAvailableSolutionStacksRequest,
      ListAvailableSolutionStacksResponse
    ]("listAvailableSolutionStacks", api.listAvailableSolutionStacks)(
      ListAvailableSolutionStacksRequest.builder().build()
    ).map(
      zio.aws.elasticbeanstalk.model.ListAvailableSolutionStacksResponse.wrap
    ).provideEnvironment(r)
    def restartAppServer(request: RestartAppServerRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.elasticbeanstalk.model.RestartAppServerRequest,
        RestartAppServerResponse
      ]("restartAppServer", api.restartAppServer)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def composeEnvironments(request: ComposeEnvironmentsRequest): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.ComposeEnvironmentsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.ComposeEnvironmentsRequest,
      ComposeEnvironmentsResponse
    ]("composeEnvironments", api.composeEnvironments)(request.buildAwsValue())
      .map(zio.aws.elasticbeanstalk.model.ComposeEnvironmentsResponse.wrap)
      .provideEnvironment(r)
    def disassociateEnvironmentOperationsRole(
        request: DisassociateEnvironmentOperationsRoleRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.DisassociateEnvironmentOperationsRoleRequest,
      DisassociateEnvironmentOperationsRoleResponse
    ](
      "disassociateEnvironmentOperationsRole",
      api.disassociateEnvironmentOperationsRole
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeApplicationVersions(
        request: DescribeApplicationVersionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ApplicationVersionDescription.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest,
      DescribeApplicationVersionsResponse,
      ApplicationVersionDescription
    ](
      "describeApplicationVersions",
      api.describeApplicationVersions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.applicationVersions().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.elasticbeanstalk.model.ApplicationVersionDescription.wrap(item)
      )
      .provideEnvironment(r)
    def describeApplicationVersionsPaginated(
        request: DescribeApplicationVersionsRequest
    ): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.DescribeApplicationVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest,
      DescribeApplicationVersionsResponse
    ]("describeApplicationVersions", api.describeApplicationVersions)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticbeanstalk.model.DescribeApplicationVersionsResponse.wrap
    ).provideEnvironment(r)
    def associateEnvironmentOperationsRole(
        request: AssociateEnvironmentOperationsRoleRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.AssociateEnvironmentOperationsRoleRequest,
      AssociateEnvironmentOperationsRoleResponse
    ](
      "associateEnvironmentOperationsRole",
      api.associateEnvironmentOperationsRole
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateApplicationResourceLifecycle(
        request: UpdateApplicationResourceLifecycleRequest
    ): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.UpdateApplicationResourceLifecycleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResourceLifecycleRequest,
      UpdateApplicationResourceLifecycleResponse
    ](
      "updateApplicationResourceLifecycle",
      api.updateApplicationResourceLifecycle
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticbeanstalk.model.UpdateApplicationResourceLifecycleResponse.wrap
      )
      .provideEnvironment(r)
    def requestEnvironmentInfo(
        request: RequestEnvironmentInfoRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest,
      RequestEnvironmentInfoResponse
    ]("requestEnvironmentInfo", api.requestEnvironmentInfo)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def rebuildEnvironment(
        request: RebuildEnvironmentRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.RebuildEnvironmentRequest,
      RebuildEnvironmentResponse
    ]("rebuildEnvironment", api.rebuildEnvironment)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeEnvironments(request: DescribeEnvironmentsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.EnvironmentDescription.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsRequest,
      DescribeEnvironmentsResponse,
      EnvironmentDescription
    ](
      "describeEnvironments",
      api.describeEnvironments,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.environments().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.elasticbeanstalk.model.EnvironmentDescription.wrap(item)
      )
      .provideEnvironment(r)
    def describeEnvironmentsPaginated(request: DescribeEnvironmentsRequest): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.DescribeEnvironmentsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsRequest,
      DescribeEnvironmentsResponse
    ]("describeEnvironments", api.describeEnvironments)(request.buildAwsValue())
      .map(zio.aws.elasticbeanstalk.model.DescribeEnvironmentsResponse.wrap)
      .provideEnvironment(r)
    def applyEnvironmentManagedAction(
        request: ApplyEnvironmentManagedActionRequest
    ): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionRequest,
      ApplyEnvironmentManagedActionResponse
    ]("applyEnvironmentManagedAction", api.applyEnvironmentManagedAction)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse.wrap
    ).provideEnvironment(r)
    def describeApplications(request: DescribeApplicationsRequest): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.DescribeApplicationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationsRequest,
      DescribeApplicationsResponse
    ]("describeApplications", api.describeApplications)(request.buildAwsValue())
      .map(zio.aws.elasticbeanstalk.model.DescribeApplicationsResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.elasticbeanstalk.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def updateEnvironment(request: UpdateEnvironmentRequest): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.UpdateEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.UpdateEnvironmentRequest,
      UpdateEnvironmentResponse
    ]("updateEnvironment", api.updateEnvironment)(request.buildAwsValue())
      .map(zio.aws.elasticbeanstalk.model.UpdateEnvironmentResponse.wrap)
      .provideEnvironment(r)
    def describeInstancesHealth(
        request: DescribeInstancesHealthRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.elasticbeanstalk.model.DescribeInstancesHealthResponse.ReadOnly,
      zio.aws.elasticbeanstalk.model.SingleInstanceHealth.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.elasticbeanstalk.model.DescribeInstancesHealthRequest,
      DescribeInstancesHealthResponse,
      SingleInstanceHealth
    ](
      "describeInstancesHealth",
      api.describeInstancesHealth,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.instanceHealthList().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.elasticbeanstalk.model.DescribeInstancesHealthResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.elasticbeanstalk.model.SingleInstanceHealth.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def describeInstancesHealthPaginated(
        request: DescribeInstancesHealthRequest
    ): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.DescribeInstancesHealthResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.DescribeInstancesHealthRequest,
      DescribeInstancesHealthResponse
    ]("describeInstancesHealth", api.describeInstancesHealth)(
      request.buildAwsValue()
    ).map(zio.aws.elasticbeanstalk.model.DescribeInstancesHealthResponse.wrap)
      .provideEnvironment(r)
    def updateApplicationVersion(request: UpdateApplicationVersionRequest): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.UpdateApplicationVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationVersionRequest,
      UpdateApplicationVersionResponse
    ]("updateApplicationVersion", api.updateApplicationVersion)(
      request.buildAwsValue()
    ).map(zio.aws.elasticbeanstalk.model.UpdateApplicationVersionResponse.wrap)
      .provideEnvironment(r)
    def terminateEnvironment(request: TerminateEnvironmentRequest): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.TerminateEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentRequest,
      TerminateEnvironmentResponse
    ]("terminateEnvironment", api.terminateEnvironment)(request.buildAwsValue())
      .map(zio.aws.elasticbeanstalk.model.TerminateEnvironmentResponse.wrap)
      .provideEnvironment(r)
    def updateApplication(
        request: UpdateApplicationRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationRequest,
      UpdateApplicationResponse
    ]("updateApplication", api.updateApplication)(request.buildAwsValue())
      .map(zio.aws.elasticbeanstalk.model.UpdateApplicationResponse.wrap)
      .provideEnvironment(r)
    def deletePlatformVersion(request: DeletePlatformVersionRequest): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.DeletePlatformVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.DeletePlatformVersionRequest,
      DeletePlatformVersionResponse
    ]("deletePlatformVersion", api.deletePlatformVersion)(
      request.buildAwsValue()
    ).map(zio.aws.elasticbeanstalk.model.DeletePlatformVersionResponse.wrap)
      .provideEnvironment(r)
    def describeEnvironmentManagedActionHistory(
        request: DescribeEnvironmentManagedActionHistoryRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ManagedActionHistoryItem.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest,
      DescribeEnvironmentManagedActionHistoryResponse,
      ManagedActionHistoryItem
    ](
      "describeEnvironmentManagedActionHistory",
      api.describeEnvironmentManagedActionHistory,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.managedActionHistoryItems().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.elasticbeanstalk.model.ManagedActionHistoryItem.wrap(item)
      )
      .provideEnvironment(r)
    def describeEnvironmentManagedActionHistoryPaginated(
        request: DescribeEnvironmentManagedActionHistoryRequest
    ): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest,
      DescribeEnvironmentManagedActionHistoryResponse
    ](
      "describeEnvironmentManagedActionHistory",
      api.describeEnvironmentManagedActionHistory
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse.wrap
      )
      .provideEnvironment(r)
    def describeAccountAttributes(): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.DescribeAccountAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeAccountAttributesRequest,
      DescribeAccountAttributesResponse
    ]("describeAccountAttributes", api.describeAccountAttributes)(
      DescribeAccountAttributesRequest.builder().build()
    ).map(zio.aws.elasticbeanstalk.model.DescribeAccountAttributesResponse.wrap)
      .provideEnvironment(r)
    def updateConfigurationTemplate(
        request: UpdateConfigurationTemplateRequest
    ): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.UpdateConfigurationTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest,
      UpdateConfigurationTemplateResponse
    ]("updateConfigurationTemplate", api.updateConfigurationTemplate)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticbeanstalk.model.UpdateConfigurationTemplateResponse.wrap
    ).provideEnvironment(r)
    def describeEnvironmentHealth(
        request: DescribeEnvironmentHealthRequest
    ): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.DescribeEnvironmentHealthResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentHealthRequest,
      DescribeEnvironmentHealthResponse
    ]("describeEnvironmentHealth", api.describeEnvironmentHealth)(
      request.buildAwsValue()
    ).map(zio.aws.elasticbeanstalk.model.DescribeEnvironmentHealthResponse.wrap)
      .provideEnvironment(r)
    def describeEvents(request: DescribeEventsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.EventDescription.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest,
      DescribeEventsResponse,
      EventDescription
    ](
      "describeEvents",
      api.describeEvents,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.events().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.elasticbeanstalk.model.EventDescription.wrap(item))
      .provideEnvironment(r)
    def describeEventsPaginated(request: DescribeEventsRequest): IO[
      AwsError,
      zio.aws.elasticbeanstalk.model.DescribeEventsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest,
      DescribeEventsResponse
    ]("describeEvents", api.describeEvents)(request.buildAwsValue())
      .map(zio.aws.elasticbeanstalk.model.DescribeEventsResponse.wrap)
      .provideEnvironment(r)
  }
  def describeConfigurationOptions(
      request: DescribeConfigurationOptionsRequest
  ): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.DescribeConfigurationOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConfigurationOptions(request))
  def createPlatformVersion(request: CreatePlatformVersionRequest): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.CreatePlatformVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPlatformVersion(request))
  def deleteApplication(
      request: DeleteApplicationRequest
  ): ZIO[zio.aws.elasticbeanstalk.ElasticBeanstalk, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteApplication(request))
  def listPlatformVersions(request: ListPlatformVersionsRequest): ZStream[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.PlatformSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listPlatformVersions(request))
  def listPlatformVersionsPaginated(request: ListPlatformVersionsRequest): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.ListPlatformVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPlatformVersionsPaginated(request))
  def checkDNSAvailability(request: CheckDnsAvailabilityRequest): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.CheckDnsAvailabilityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.checkDNSAvailability(request))
  def validateConfigurationSettings(
      request: ValidateConfigurationSettingsRequest
  ): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.ValidateConfigurationSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.validateConfigurationSettings(request))
  def retrieveEnvironmentInfo(request: RetrieveEnvironmentInfoRequest): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.RetrieveEnvironmentInfoResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.retrieveEnvironmentInfo(request))
  def describePlatformVersion(request: DescribePlatformVersionRequest): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.DescribePlatformVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePlatformVersion(request))
  def updateTagsForResource(
      request: UpdateTagsForResourceRequest
  ): ZIO[zio.aws.elasticbeanstalk.ElasticBeanstalk, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateTagsForResource(request))
  def deleteApplicationVersion(
      request: DeleteApplicationVersionRequest
  ): ZIO[zio.aws.elasticbeanstalk.ElasticBeanstalk, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteApplicationVersion(request))
  def listPlatformBranches(request: ListPlatformBranchesRequest): ZStream[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.PlatformBranchSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listPlatformBranches(request))
  def listPlatformBranchesPaginated(request: ListPlatformBranchesRequest): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.ListPlatformBranchesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPlatformBranchesPaginated(request))
  def createApplicationVersion(request: CreateApplicationVersionRequest): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.CreateApplicationVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApplicationVersion(request))
  def createEnvironment(request: CreateEnvironmentRequest): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.CreateEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEnvironment(request))
  def deleteConfigurationTemplate(
      request: DeleteConfigurationTemplateRequest
  ): ZIO[zio.aws.elasticbeanstalk.ElasticBeanstalk, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteConfigurationTemplate(request))
  def createApplication(request: CreateApplicationRequest): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.CreateApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApplication(request))
  def createConfigurationTemplate(
      request: CreateConfigurationTemplateRequest
  ): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.CreateConfigurationTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createConfigurationTemplate(request))
  def describeEnvironmentManagedActions(
      request: DescribeEnvironmentManagedActionsRequest
  ): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEnvironmentManagedActions(request))
  def describeEnvironmentResources(
      request: DescribeEnvironmentResourcesRequest
  ): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.DescribeEnvironmentResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEnvironmentResources(request))
  def createStorageLocation(): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.CreateStorageLocationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createStorageLocation())
  def deleteEnvironmentConfiguration(
      request: DeleteEnvironmentConfigurationRequest
  ): ZIO[zio.aws.elasticbeanstalk.ElasticBeanstalk, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteEnvironmentConfiguration(request))
  def abortEnvironmentUpdate(
      request: AbortEnvironmentUpdateRequest
  ): ZIO[zio.aws.elasticbeanstalk.ElasticBeanstalk, AwsError, Unit] =
    ZIO.serviceWithZIO(_.abortEnvironmentUpdate(request))
  def swapEnvironmentCNAMEs(
      request: SwapEnvironmentCnamEsRequest
  ): ZIO[zio.aws.elasticbeanstalk.ElasticBeanstalk, AwsError, Unit] =
    ZIO.serviceWithZIO(_.swapEnvironmentCNAMEs(request))
  def describeConfigurationSettings(
      request: DescribeConfigurationSettingsRequest
  ): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.DescribeConfigurationSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConfigurationSettings(request))
  def listAvailableSolutionStacks(): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.ListAvailableSolutionStacksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAvailableSolutionStacks())
  def restartAppServer(
      request: RestartAppServerRequest
  ): ZIO[zio.aws.elasticbeanstalk.ElasticBeanstalk, AwsError, Unit] =
    ZIO.serviceWithZIO(_.restartAppServer(request))
  def composeEnvironments(request: ComposeEnvironmentsRequest): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.ComposeEnvironmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.composeEnvironments(request))
  def disassociateEnvironmentOperationsRole(
      request: DisassociateEnvironmentOperationsRoleRequest
  ): ZIO[zio.aws.elasticbeanstalk.ElasticBeanstalk, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disassociateEnvironmentOperationsRole(request))
  def describeApplicationVersions(
      request: DescribeApplicationVersionsRequest
  ): ZStream[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.ApplicationVersionDescription.ReadOnly
  ] = ZStream.serviceWithStream(_.describeApplicationVersions(request))
  def describeApplicationVersionsPaginated(
      request: DescribeApplicationVersionsRequest
  ): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.DescribeApplicationVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeApplicationVersionsPaginated(request))
  def associateEnvironmentOperationsRole(
      request: AssociateEnvironmentOperationsRoleRequest
  ): ZIO[zio.aws.elasticbeanstalk.ElasticBeanstalk, AwsError, Unit] =
    ZIO.serviceWithZIO(_.associateEnvironmentOperationsRole(request))
  def updateApplicationResourceLifecycle(
      request: UpdateApplicationResourceLifecycleRequest
  ): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.UpdateApplicationResourceLifecycleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApplicationResourceLifecycle(request))
  def requestEnvironmentInfo(
      request: RequestEnvironmentInfoRequest
  ): ZIO[zio.aws.elasticbeanstalk.ElasticBeanstalk, AwsError, Unit] =
    ZIO.serviceWithZIO(_.requestEnvironmentInfo(request))
  def rebuildEnvironment(
      request: RebuildEnvironmentRequest
  ): ZIO[zio.aws.elasticbeanstalk.ElasticBeanstalk, AwsError, Unit] =
    ZIO.serviceWithZIO(_.rebuildEnvironment(request))
  def describeEnvironments(request: DescribeEnvironmentsRequest): ZStream[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.EnvironmentDescription.ReadOnly
  ] = ZStream.serviceWithStream(_.describeEnvironments(request))
  def describeEnvironmentsPaginated(request: DescribeEnvironmentsRequest): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.DescribeEnvironmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEnvironmentsPaginated(request))
  def applyEnvironmentManagedAction(
      request: ApplyEnvironmentManagedActionRequest
  ): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.applyEnvironmentManagedAction(request))
  def describeApplications(request: DescribeApplicationsRequest): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.DescribeApplicationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeApplications(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def updateEnvironment(request: UpdateEnvironmentRequest): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.UpdateEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEnvironment(request))
  def describeInstancesHealth(request: DescribeInstancesHealthRequest): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.elasticbeanstalk.model.DescribeInstancesHealthResponse.ReadOnly,
      zio.aws.elasticbeanstalk.model.SingleInstanceHealth.ReadOnly
    ]
  ] = ZIO.serviceWithZIO(_.describeInstancesHealth(request))
  def describeInstancesHealthPaginated(
      request: DescribeInstancesHealthRequest
  ): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.DescribeInstancesHealthResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInstancesHealthPaginated(request))
  def updateApplicationVersion(request: UpdateApplicationVersionRequest): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.UpdateApplicationVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApplicationVersion(request))
  def terminateEnvironment(request: TerminateEnvironmentRequest): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.TerminateEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.terminateEnvironment(request))
  def updateApplication(
      request: UpdateApplicationRequest
  ): ZIO[zio.aws.elasticbeanstalk.ElasticBeanstalk, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.updateApplication(request))
  def deletePlatformVersion(request: DeletePlatformVersionRequest): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.DeletePlatformVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePlatformVersion(request))
  def describeEnvironmentManagedActionHistory(
      request: DescribeEnvironmentManagedActionHistoryRequest
  ): ZStream[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.ManagedActionHistoryItem.ReadOnly
  ] = ZStream.serviceWithStream(
    _.describeEnvironmentManagedActionHistory(request)
  )
  def describeEnvironmentManagedActionHistoryPaginated(
      request: DescribeEnvironmentManagedActionHistoryRequest
  ): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeEnvironmentManagedActionHistoryPaginated(request)
  )
  def describeAccountAttributes(): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.DescribeAccountAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAccountAttributes())
  def updateConfigurationTemplate(
      request: UpdateConfigurationTemplateRequest
  ): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.UpdateConfigurationTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateConfigurationTemplate(request))
  def describeEnvironmentHealth(request: DescribeEnvironmentHealthRequest): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.DescribeEnvironmentHealthResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEnvironmentHealth(request))
  def describeEvents(request: DescribeEventsRequest): ZStream[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.EventDescription.ReadOnly
  ] = ZStream.serviceWithStream(_.describeEvents(request))
  def describeEventsPaginated(request: DescribeEventsRequest): ZIO[
    zio.aws.elasticbeanstalk.ElasticBeanstalk,
    AwsError,
    zio.aws.elasticbeanstalk.model.DescribeEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventsPaginated(request))
}
