package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{
  ConfigurationOptionName,
  OptionNamespace,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class OptionSpecification(
    resourceName: Option[ResourceName] = None,
    namespace: Option[OptionNamespace] = None,
    optionName: Option[ConfigurationOptionName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.OptionSpecification = {
    import OptionSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.OptionSpecification
      .builder()
      .optionallyWith(
        resourceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.resourceName)
      .optionallyWith(
        namespace.map(value => OptionNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        optionName.map(value =>
          ConfigurationOptionName.unwrap(value): java.lang.String
        )
      )(_.optionName)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.OptionSpecification.ReadOnly =
    zio.aws.elasticbeanstalk.model.OptionSpecification.wrap(buildAwsValue())
}
object OptionSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.OptionSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.OptionSpecification =
      zio.aws.elasticbeanstalk.model.OptionSpecification(
        resourceName.map(value => value),
        namespace.map(value => value),
        optionName.map(value => value)
      )
    def resourceName: Option[ResourceName]
    def namespace: Option[OptionNamespace]
    def optionName: Option[ConfigurationOptionName]
    def getResourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("resourceName", resourceName)
    def getNamespace: ZIO[Any, AwsError, OptionNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getOptionName: ZIO[Any, AwsError, ConfigurationOptionName] =
      AwsError.unwrapOptionField("optionName", optionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.OptionSpecification
  ) extends zio.aws.elasticbeanstalk.model.OptionSpecification.ReadOnly {
    override val resourceName: Option[ResourceName] = scala
      .Option(impl.resourceName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.ResourceName(value)
      )
    override val namespace: Option[OptionNamespace] = scala
      .Option(impl.namespace())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.OptionNamespace(value)
      )
    override val optionName: Option[ConfigurationOptionName] = scala
      .Option(impl.optionName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.ConfigurationOptionName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.OptionSpecification
  ): zio.aws.elasticbeanstalk.model.OptionSpecification.ReadOnly = new Wrapper(
    impl
  )
}
