package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.ApplicationName
import scala.jdk.CollectionConverters._
final case class DescribeApplicationsRequest(
    applicationNames: Option[Iterable[ApplicationName]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationsRequest = {
    import DescribeApplicationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationsRequest
      .builder()
      .optionallyWith(
        applicationNames.map(value =>
          value.map { item =>
            ApplicationName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.applicationNames)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeApplicationsRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeApplicationsRequest
      .wrap(buildAwsValue())
}
object DescribeApplicationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.DescribeApplicationsRequest =
      zio.aws.elasticbeanstalk.model
        .DescribeApplicationsRequest(applicationNames.map(value => value))
    def applicationNames: Option[List[ApplicationName]]
    def getApplicationNames: ZIO[Any, AwsError, List[ApplicationName]] =
      AwsError.unwrapOptionField("applicationNames", applicationNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationsRequest
  ) extends zio.aws.elasticbeanstalk.model.DescribeApplicationsRequest.ReadOnly {
    override val applicationNames: Option[List[ApplicationName]] = scala
      .Option(impl.applicationNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.primitives.ApplicationName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationsRequest
  ): zio.aws.elasticbeanstalk.model.DescribeApplicationsRequest.ReadOnly =
    new Wrapper(impl)
}
