package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.elasticbeanstalk.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class ManagedAction(
    actionId: Option[String] = None,
    actionDescription: Option[String] = None,
    actionType: Option[zio.aws.elasticbeanstalk.model.ActionType] = None,
    status: Option[zio.aws.elasticbeanstalk.model.ActionStatus] = None,
    windowStartTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ManagedAction = {
    import ManagedAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ManagedAction
      .builder()
      .optionallyWith(actionId.map(value => value: java.lang.String))(
        _.actionId
      )
      .optionallyWith(actionDescription.map(value => value: java.lang.String))(
        _.actionDescription
      )
      .optionallyWith(actionType.map(value => value.unwrap))(_.actionType)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        windowStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.windowStartTime)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.ManagedAction.ReadOnly =
    zio.aws.elasticbeanstalk.model.ManagedAction.wrap(buildAwsValue())
}
object ManagedAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ManagedAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.ManagedAction =
      zio.aws.elasticbeanstalk.model.ManagedAction(
        actionId.map(value => value),
        actionDescription.map(value => value),
        actionType.map(value => value),
        status.map(value => value),
        windowStartTime.map(value => value)
      )
    def actionId: Option[String]
    def actionDescription: Option[String]
    def actionType: Option[zio.aws.elasticbeanstalk.model.ActionType]
    def status: Option[zio.aws.elasticbeanstalk.model.ActionStatus]
    def windowStartTime: Option[Timestamp]
    def getActionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("actionId", actionId)
    def getActionDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("actionDescription", actionDescription)
    def getActionType
        : ZIO[Any, AwsError, zio.aws.elasticbeanstalk.model.ActionType] =
      AwsError.unwrapOptionField("actionType", actionType)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.elasticbeanstalk.model.ActionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getWindowStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("windowStartTime", windowStartTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ManagedAction
  ) extends zio.aws.elasticbeanstalk.model.ManagedAction.ReadOnly {
    override val actionId: Option[String] =
      scala.Option(impl.actionId()).map(value => value: String)
    override val actionDescription: Option[String] =
      scala.Option(impl.actionDescription()).map(value => value: String)
    override val actionType: Option[zio.aws.elasticbeanstalk.model.ActionType] =
      scala
        .Option(impl.actionType())
        .map(value => zio.aws.elasticbeanstalk.model.ActionType.wrap(value))
    override val status: Option[zio.aws.elasticbeanstalk.model.ActionStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.elasticbeanstalk.model.ActionStatus.wrap(value))
    override val windowStartTime: Option[Timestamp] = scala
      .Option(impl.windowStartTime())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ManagedAction
  ): zio.aws.elasticbeanstalk.model.ManagedAction.ReadOnly = new Wrapper(impl)
}
