package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elasticbeanstalk.model.primitives.{
  EnvironmentName,
  ApplicationName
}
import scala.jdk.CollectionConverters._
final case class DeleteEnvironmentConfigurationRequest(
    applicationName: ApplicationName,
    environmentName: EnvironmentName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest = {
    import DeleteEnvironmentConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .environmentName(
        EnvironmentName.unwrap(environmentName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteEnvironmentConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest =
      zio.aws.elasticbeanstalk.model
        .DeleteEnvironmentConfigurationRequest(applicationName, environmentName)
    def applicationName: ApplicationName
    def environmentName: EnvironmentName
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getEnvironmentName: ZIO[Any, Nothing, EnvironmentName] =
      ZIO.succeed(environmentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest
  ) extends zio.aws.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.elasticbeanstalk.model.primitives
        .ApplicationName(impl.applicationName())
    override val environmentName: EnvironmentName =
      zio.aws.elasticbeanstalk.model.primitives
        .EnvironmentName(impl.environmentName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest
  ): zio.aws.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
