package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class Listener(
    protocol: Option[String] = None,
    port: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.Listener = {
    import Listener.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.Listener
      .builder()
      .optionallyWith(protocol.map(value => value: java.lang.String))(
        _.protocol
      )
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.Listener.ReadOnly =
    zio.aws.elasticbeanstalk.model.Listener.wrap(buildAwsValue())
}
object Listener {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.Listener
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.Listener =
      zio.aws.elasticbeanstalk.model
        .Listener(protocol.map(value => value), port.map(value => value))
    def protocol: Option[String]
    def port: Option[Integer]
    def getProtocol: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.Listener
  ) extends zio.aws.elasticbeanstalk.model.Listener.ReadOnly {
    override val protocol: Option[String] =
      scala.Option(impl.protocol()).map(value => value: String)
    override val port: Option[Integer] =
      scala.Option(impl.port()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.Listener
  ): zio.aws.elasticbeanstalk.model.Listener.ReadOnly = new Wrapper(impl)
}
