package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LoadBalancerDescription(
    loadBalancerName: Option[String] = None,
    domain: Option[String] = None,
    listeners: Option[Iterable[zio.aws.elasticbeanstalk.model.Listener]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.LoadBalancerDescription = {
    import LoadBalancerDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.LoadBalancerDescription
      .builder()
      .optionallyWith(loadBalancerName.map(value => value: java.lang.String))(
        _.loadBalancerName
      )
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(
        listeners.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.listeners)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.LoadBalancerDescription.ReadOnly =
    zio.aws.elasticbeanstalk.model.LoadBalancerDescription.wrap(buildAwsValue())
}
object LoadBalancerDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.LoadBalancerDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.LoadBalancerDescription =
      zio.aws.elasticbeanstalk.model.LoadBalancerDescription(
        loadBalancerName.map(value => value),
        domain.map(value => value),
        listeners.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def loadBalancerName: Option[String]
    def domain: Option[String]
    def listeners
        : Option[List[zio.aws.elasticbeanstalk.model.Listener.ReadOnly]]
    def getLoadBalancerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("loadBalancerName", loadBalancerName)
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getListeners: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.Listener.ReadOnly
    ]] = AwsError.unwrapOptionField("listeners", listeners)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.LoadBalancerDescription
  ) extends zio.aws.elasticbeanstalk.model.LoadBalancerDescription.ReadOnly {
    override val loadBalancerName: Option[String] =
      scala.Option(impl.loadBalancerName()).map(value => value: String)
    override val domain: Option[String] =
      scala.Option(impl.domain()).map(value => value: String)
    override val listeners
        : Option[List[zio.aws.elasticbeanstalk.model.Listener.ReadOnly]] = scala
      .Option(impl.listeners())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.Listener.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.LoadBalancerDescription
  ): zio.aws.elasticbeanstalk.model.LoadBalancerDescription.ReadOnly =
    new Wrapper(impl)
}
