package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class LaunchTemplate(id: Option[ResourceId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.LaunchTemplate = {
    import LaunchTemplate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.LaunchTemplate
      .builder()
      .optionallyWith(
        id.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.LaunchTemplate.ReadOnly =
    zio.aws.elasticbeanstalk.model.LaunchTemplate.wrap(buildAwsValue())
}
object LaunchTemplate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.LaunchTemplate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.LaunchTemplate =
      zio.aws.elasticbeanstalk.model.LaunchTemplate(id.map(value => value))
    def id: Option[ResourceId]
    def getId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.LaunchTemplate
  ) extends zio.aws.elasticbeanstalk.model.LaunchTemplate.ReadOnly {
    override val id: Option[ResourceId] = scala
      .Option(impl.id())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.ResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.LaunchTemplate
  ): zio.aws.elasticbeanstalk.model.LaunchTemplate.ReadOnly = new Wrapper(impl)
}
