package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{
  EnvironmentId,
  EnvironmentName
}
import scala.jdk.CollectionConverters._
final case class DescribeEnvironmentHealthRequest(
    environmentName: Option[EnvironmentName] = None,
    environmentId: Option[EnvironmentId] = None,
    attributeNames: Option[
      Iterable[zio.aws.elasticbeanstalk.model.EnvironmentHealthAttribute]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentHealthRequest = {
    import DescribeEnvironmentHealthRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentHealthRequest
      .builder()
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        attributeNames.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.attributeNamesWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeEnvironmentHealthRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeEnvironmentHealthRequest
      .wrap(buildAwsValue())
}
object DescribeEnvironmentHealthRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentHealthRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DescribeEnvironmentHealthRequest =
      zio.aws.elasticbeanstalk.model.DescribeEnvironmentHealthRequest(
        environmentName.map(value => value),
        environmentId.map(value => value),
        attributeNames.map(value => value)
      )
    def environmentName: Option[EnvironmentName]
    def environmentId: Option[EnvironmentId]
    def attributeNames: Option[
      List[zio.aws.elasticbeanstalk.model.EnvironmentHealthAttribute]
    ]
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getAttributeNames: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.EnvironmentHealthAttribute
    ]] = AwsError.unwrapOptionField("attributeNames", attributeNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentHealthRequest
  ) extends zio.aws.elasticbeanstalk.model.DescribeEnvironmentHealthRequest.ReadOnly {
    override val environmentName: Option[EnvironmentName] = scala
      .Option(impl.environmentName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
      )
    override val environmentId: Option[EnvironmentId] = scala
      .Option(impl.environmentId())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentId(value)
      )
    override val attributeNames: Option[
      List[zio.aws.elasticbeanstalk.model.EnvironmentHealthAttribute]
    ] = scala
      .Option(impl.attributeNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.EnvironmentHealthAttribute.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentHealthRequest
  ): zio.aws.elasticbeanstalk.model.DescribeEnvironmentHealthRequest.ReadOnly =
    new Wrapper(impl)
}
