package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{DNSCname, CnameAvailability}
import scala.jdk.CollectionConverters._
final case class CheckDnsAvailabilityResponse(
    available: Option[CnameAvailability] = None,
    fullyQualifiedCNAME: Option[DNSCname] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.CheckDnsAvailabilityResponse = {
    import CheckDnsAvailabilityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.CheckDnsAvailabilityResponse
      .builder()
      .optionallyWith(
        available.map(value =>
          CnameAvailability.unwrap(value): java.lang.Boolean
        )
      )(_.available)
      .optionallyWith(
        fullyQualifiedCNAME.map(value =>
          DNSCname.unwrap(value): java.lang.String
        )
      )(_.fullyQualifiedCNAME)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.CheckDnsAvailabilityResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.CheckDnsAvailabilityResponse
      .wrap(buildAwsValue())
}
object CheckDnsAvailabilityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.CheckDnsAvailabilityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.CheckDnsAvailabilityResponse =
      zio.aws.elasticbeanstalk.model.CheckDnsAvailabilityResponse(
        available.map(value => value),
        fullyQualifiedCNAME.map(value => value)
      )
    def available: Option[CnameAvailability]
    def fullyQualifiedCNAME: Option[DNSCname]
    def getAvailable: ZIO[Any, AwsError, CnameAvailability] =
      AwsError.unwrapOptionField("available", available)
    def getFullyQualifiedCNAME: ZIO[Any, AwsError, DNSCname] =
      AwsError.unwrapOptionField("fullyQualifiedCNAME", fullyQualifiedCNAME)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CheckDnsAvailabilityResponse
  ) extends zio.aws.elasticbeanstalk.model.CheckDnsAvailabilityResponse.ReadOnly {
    override val available: Option[CnameAvailability] = scala
      .Option(impl.available())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.CnameAvailability(value)
      )
    override val fullyQualifiedCNAME: Option[DNSCname] = scala
      .Option(impl.fullyQualifiedCNAME())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.DNSCname(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CheckDnsAvailabilityResponse
  ): zio.aws.elasticbeanstalk.model.CheckDnsAvailabilityResponse.ReadOnly =
    new Wrapper(impl)
}
