package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{
  EnvironmentName,
  EnvironmentId
}
import scala.jdk.CollectionConverters._
final case class RetrieveEnvironmentInfoRequest(
    environmentId: Option[EnvironmentId] = None,
    environmentName: Option[EnvironmentName] = None,
    infoType: zio.aws.elasticbeanstalk.model.EnvironmentInfoType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest = {
    import RetrieveEnvironmentInfoRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest
      .builder()
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .infoType(infoType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest
      .wrap(buildAwsValue())
}
object RetrieveEnvironmentInfoRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest =
      zio.aws.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest(
        environmentId.map(value => value),
        environmentName.map(value => value),
        infoType
      )
    def environmentId: Option[EnvironmentId]
    def environmentName: Option[EnvironmentName]
    def infoType: zio.aws.elasticbeanstalk.model.EnvironmentInfoType
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getInfoType: ZIO[
      Any,
      Nothing,
      zio.aws.elasticbeanstalk.model.EnvironmentInfoType
    ] = ZIO.succeed(infoType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest
  ) extends zio.aws.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest.ReadOnly {
    override val environmentId: Option[EnvironmentId] = scala
      .Option(impl.environmentId())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentId(value)
      )
    override val environmentName: Option[EnvironmentName] = scala
      .Option(impl.environmentName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
      )
    override val infoType: zio.aws.elasticbeanstalk.model.EnvironmentInfoType =
      zio.aws.elasticbeanstalk.model.EnvironmentInfoType.wrap(impl.infoType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest
  ): zio.aws.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest.ReadOnly =
    new Wrapper(impl)
}
