package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{
  PlatformArn,
  SolutionStackName
}
import scala.jdk.CollectionConverters._
final case class DescribeConfigurationOptionsResponse(
    solutionStackName: Option[SolutionStackName] = None,
    platformArn: Option[PlatformArn] = None,
    options: Option[
      Iterable[zio.aws.elasticbeanstalk.model.ConfigurationOptionDescription]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsResponse = {
    import DescribeConfigurationOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsResponse
      .builder()
      .optionallyWith(
        solutionStackName.map(value =>
          SolutionStackName.unwrap(value): java.lang.String
        )
      )(_.solutionStackName)
      .optionallyWith(
        platformArn.map(value => PlatformArn.unwrap(value): java.lang.String)
      )(_.platformArn)
      .optionallyWith(
        options.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.options)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeConfigurationOptionsResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeConfigurationOptionsResponse
      .wrap(buildAwsValue())
}
object DescribeConfigurationOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DescribeConfigurationOptionsResponse =
      zio.aws.elasticbeanstalk.model.DescribeConfigurationOptionsResponse(
        solutionStackName.map(value => value),
        platformArn.map(value => value),
        options.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def solutionStackName: Option[SolutionStackName]
    def platformArn: Option[PlatformArn]
    def options: Option[List[
      zio.aws.elasticbeanstalk.model.ConfigurationOptionDescription.ReadOnly
    ]]
    def getSolutionStackName: ZIO[Any, AwsError, SolutionStackName] =
      AwsError.unwrapOptionField("solutionStackName", solutionStackName)
    def getPlatformArn: ZIO[Any, AwsError, PlatformArn] =
      AwsError.unwrapOptionField("platformArn", platformArn)
    def getOptions: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.ConfigurationOptionDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("options", options)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsResponse
  ) extends zio.aws.elasticbeanstalk.model.DescribeConfigurationOptionsResponse.ReadOnly {
    override val solutionStackName: Option[SolutionStackName] = scala
      .Option(impl.solutionStackName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.SolutionStackName(value)
      )
    override val platformArn: Option[PlatformArn] = scala
      .Option(impl.platformArn())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformArn(value)
      )
    override val options: Option[List[
      zio.aws.elasticbeanstalk.model.ConfigurationOptionDescription.ReadOnly
    ]] = scala
      .Option(impl.options())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.ConfigurationOptionDescription
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsResponse
  ): zio.aws.elasticbeanstalk.model.DescribeConfigurationOptionsResponse.ReadOnly =
    new Wrapper(impl)
}
