package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{
  VersionLabel,
  GroupName,
  ApplicationName
}
import scala.jdk.CollectionConverters._
final case class ComposeEnvironmentsRequest(
    applicationName: Option[ApplicationName] = None,
    groupName: Option[GroupName] = None,
    versionLabels: Option[Iterable[VersionLabel]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ComposeEnvironmentsRequest = {
    import ComposeEnvironmentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ComposeEnvironmentsRequest
      .builder()
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        groupName.map(value => GroupName.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        versionLabels.map(value =>
          value.map { item =>
            VersionLabel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.versionLabels)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ComposeEnvironmentsRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.ComposeEnvironmentsRequest
      .wrap(buildAwsValue())
}
object ComposeEnvironmentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ComposeEnvironmentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.ComposeEnvironmentsRequest =
      zio.aws.elasticbeanstalk.model.ComposeEnvironmentsRequest(
        applicationName.map(value => value),
        groupName.map(value => value),
        versionLabels.map(value => value)
      )
    def applicationName: Option[ApplicationName]
    def groupName: Option[GroupName]
    def versionLabels: Option[List[VersionLabel]]
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getGroupName: ZIO[Any, AwsError, GroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getVersionLabels: ZIO[Any, AwsError, List[VersionLabel]] =
      AwsError.unwrapOptionField("versionLabels", versionLabels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ComposeEnvironmentsRequest
  ) extends zio.aws.elasticbeanstalk.model.ComposeEnvironmentsRequest.ReadOnly {
    override val applicationName: Option[ApplicationName] = scala
      .Option(impl.applicationName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.ApplicationName(value)
      )
    override val groupName: Option[GroupName] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.GroupName(value))
    override val versionLabels: Option[List[VersionLabel]] = scala
      .Option(impl.versionLabels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.primitives.VersionLabel(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ComposeEnvironmentsRequest
  ): zio.aws.elasticbeanstalk.model.ComposeEnvironmentsRequest.ReadOnly =
    new Wrapper(impl)
}
