package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{
  EnvironmentName,
  EnvironmentId
}
import scala.jdk.CollectionConverters._
final case class AbortEnvironmentUpdateRequest(
    environmentId: Option[EnvironmentId] = None,
    environmentName: Option[EnvironmentName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest = {
    import AbortEnvironmentUpdateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest
      .builder()
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.AbortEnvironmentUpdateRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.AbortEnvironmentUpdateRequest
      .wrap(buildAwsValue())
}
object AbortEnvironmentUpdateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.AbortEnvironmentUpdateRequest =
      zio.aws.elasticbeanstalk.model.AbortEnvironmentUpdateRequest(
        environmentId.map(value => value),
        environmentName.map(value => value)
      )
    def environmentId: Option[EnvironmentId]
    def environmentName: Option[EnvironmentName]
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest
  ) extends zio.aws.elasticbeanstalk.model.AbortEnvironmentUpdateRequest.ReadOnly {
    override val environmentId: Option[EnvironmentId] = scala
      .Option(impl.environmentId())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentId(value)
      )
    override val environmentName: Option[EnvironmentName] = scala
      .Option(impl.environmentName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest
  ): zio.aws.elasticbeanstalk.model.AbortEnvironmentUpdateRequest.ReadOnly =
    new Wrapper(impl)
}
