package zio.aws.elasticbeanstalk.model
import scala.jdk.CollectionConverters._
sealed trait PlatformStatus {
  def unwrap
      : software.amazon.awssdk.services.elasticbeanstalk.model.PlatformStatus
}
object PlatformStatus {
  def wrap(
      value: software.amazon.awssdk.services.elasticbeanstalk.model.PlatformStatus
  ): zio.aws.elasticbeanstalk.model.PlatformStatus = value match {
    case software.amazon.awssdk.services.elasticbeanstalk.model.PlatformStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.PlatformStatus.CREATING =>
      val r = Creating
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.PlatformStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.PlatformStatus.READY =>
      val r = Ready
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.PlatformStatus.DELETING =>
      val r = Deleting
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.PlatformStatus.DELETED =>
      val r = Deleted
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticbeanstalk.model.PlatformStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.PlatformStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.PlatformStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Creating extends zio.aws.elasticbeanstalk.model.PlatformStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.PlatformStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.PlatformStatus.CREATING
  }
  case object Failed extends zio.aws.elasticbeanstalk.model.PlatformStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.PlatformStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.PlatformStatus.FAILED
  }
  case object Ready extends zio.aws.elasticbeanstalk.model.PlatformStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.PlatformStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.PlatformStatus.READY
  }
  case object Deleting extends zio.aws.elasticbeanstalk.model.PlatformStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.PlatformStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.PlatformStatus.DELETING
  }
  case object Deleted extends zio.aws.elasticbeanstalk.model.PlatformStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.PlatformStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.PlatformStatus.DELETED
  }
}
