package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.elasticbeanstalk.model.primitives.{
  Message,
  SampleTimestamp,
  Ec2InstanceId
}
import scala.jdk.CollectionConverters._
final case class EnvironmentInfoDescription(
    infoType: Option[zio.aws.elasticbeanstalk.model.EnvironmentInfoType] = None,
    ec2InstanceId: Option[Ec2InstanceId] = None,
    sampleTimestamp: Option[SampleTimestamp] = None,
    message: Option[Message] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoDescription = {
    import EnvironmentInfoDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoDescription
      .builder()
      .optionallyWith(infoType.map(value => value.unwrap))(_.infoType)
      .optionallyWith(
        ec2InstanceId.map(value =>
          Ec2InstanceId.unwrap(value): java.lang.String
        )
      )(_.ec2InstanceId)
      .optionallyWith(
        sampleTimestamp.map(value => SampleTimestamp.unwrap(value): Instant)
      )(_.sampleTimestamp)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.EnvironmentInfoDescription.ReadOnly =
    zio.aws.elasticbeanstalk.model.EnvironmentInfoDescription
      .wrap(buildAwsValue())
}
object EnvironmentInfoDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.EnvironmentInfoDescription =
      zio.aws.elasticbeanstalk.model.EnvironmentInfoDescription(
        infoType.map(value => value),
        ec2InstanceId.map(value => value),
        sampleTimestamp.map(value => value),
        message.map(value => value)
      )
    def infoType: Option[zio.aws.elasticbeanstalk.model.EnvironmentInfoType]
    def ec2InstanceId: Option[Ec2InstanceId]
    def sampleTimestamp: Option[SampleTimestamp]
    def message: Option[Message]
    def getInfoType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.EnvironmentInfoType
    ] = AwsError.unwrapOptionField("infoType", infoType)
    def getEc2InstanceId: ZIO[Any, AwsError, Ec2InstanceId] =
      AwsError.unwrapOptionField("ec2InstanceId", ec2InstanceId)
    def getSampleTimestamp: ZIO[Any, AwsError, SampleTimestamp] =
      AwsError.unwrapOptionField("sampleTimestamp", sampleTimestamp)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoDescription
  ) extends zio.aws.elasticbeanstalk.model.EnvironmentInfoDescription.ReadOnly {
    override val infoType
        : Option[zio.aws.elasticbeanstalk.model.EnvironmentInfoType] = scala
      .Option(impl.infoType())
      .map(value =>
        zio.aws.elasticbeanstalk.model.EnvironmentInfoType.wrap(value)
      )
    override val ec2InstanceId: Option[Ec2InstanceId] = scala
      .Option(impl.ec2InstanceId())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.Ec2InstanceId(value)
      )
    override val sampleTimestamp: Option[SampleTimestamp] = scala
      .Option(impl.sampleTimestamp())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.SampleTimestamp(value)
      )
    override val message: Option[Message] = scala
      .Option(impl.message())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.Message(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoDescription
  ): zio.aws.elasticbeanstalk.model.EnvironmentInfoDescription.ReadOnly =
    new Wrapper(impl)
}
