package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elasticbeanstalk.model.primitives.{
  ConfigurationTemplateName,
  ApplicationName
}
import scala.jdk.CollectionConverters._
final case class DeleteConfigurationTemplateRequest(
    applicationName: ApplicationName,
    templateName: ConfigurationTemplateName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest = {
    import DeleteConfigurationTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .templateName(
        ConfigurationTemplateName.unwrap(templateName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DeleteConfigurationTemplateRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.DeleteConfigurationTemplateRequest
      .wrap(buildAwsValue())
}
object DeleteConfigurationTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DeleteConfigurationTemplateRequest =
      zio.aws.elasticbeanstalk.model
        .DeleteConfigurationTemplateRequest(applicationName, templateName)
    def applicationName: ApplicationName
    def templateName: ConfigurationTemplateName
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getTemplateName: ZIO[Any, Nothing, ConfigurationTemplateName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest
  ) extends zio.aws.elasticbeanstalk.model.DeleteConfigurationTemplateRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.elasticbeanstalk.model.primitives
        .ApplicationName(impl.applicationName())
    override val templateName: ConfigurationTemplateName =
      zio.aws.elasticbeanstalk.model.primitives
        .ConfigurationTemplateName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest
  ): zio.aws.elasticbeanstalk.model.DeleteConfigurationTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
