package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{
  ConfigurationTemplateName,
  DNSCnamePrefix,
  ApplicationName,
  OperationsRole,
  EnvironmentName,
  SolutionStackName,
  VersionLabel,
  PlatformArn,
  Description,
  GroupName
}
import scala.jdk.CollectionConverters._
final case class CreateEnvironmentRequest(
    applicationName: ApplicationName,
    environmentName: Option[EnvironmentName] = None,
    groupName: Option[GroupName] = None,
    description: Option[Description] = None,
    cnamePrefix: Option[DNSCnamePrefix] = None,
    tier: Option[zio.aws.elasticbeanstalk.model.EnvironmentTier] = None,
    tags: Option[Iterable[zio.aws.elasticbeanstalk.model.Tag]] = None,
    versionLabel: Option[VersionLabel] = None,
    templateName: Option[ConfigurationTemplateName] = None,
    solutionStackName: Option[SolutionStackName] = None,
    platformArn: Option[PlatformArn] = None,
    optionSettings: Option[
      Iterable[zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting]
    ] = None,
    optionsToRemove: Option[
      Iterable[zio.aws.elasticbeanstalk.model.OptionSpecification]
    ] = None,
    operationsRole: Option[OperationsRole] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.CreateEnvironmentRequest = {
    import CreateEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.CreateEnvironmentRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(
        groupName.map(value => GroupName.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        cnamePrefix.map(value => DNSCnamePrefix.unwrap(value): java.lang.String)
      )(_.cnamePrefix)
      .optionallyWith(tier.map(value => value.buildAwsValue()))(_.tier)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        versionLabel.map(value => VersionLabel.unwrap(value): java.lang.String)
      )(_.versionLabel)
      .optionallyWith(
        templateName.map(value =>
          ConfigurationTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        solutionStackName.map(value =>
          SolutionStackName.unwrap(value): java.lang.String
        )
      )(_.solutionStackName)
      .optionallyWith(
        platformArn.map(value => PlatformArn.unwrap(value): java.lang.String)
      )(_.platformArn)
      .optionallyWith(
        optionSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionSettings)
      .optionallyWith(
        optionsToRemove.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionsToRemove)
      .optionallyWith(
        operationsRole.map(value =>
          OperationsRole.unwrap(value): java.lang.String
        )
      )(_.operationsRole)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.CreateEnvironmentRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.CreateEnvironmentRequest
      .wrap(buildAwsValue())
}
object CreateEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.CreateEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.CreateEnvironmentRequest =
      zio.aws.elasticbeanstalk.model.CreateEnvironmentRequest(
        applicationName,
        environmentName.map(value => value),
        groupName.map(value => value),
        description.map(value => value),
        cnamePrefix.map(value => value),
        tier.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        versionLabel.map(value => value),
        templateName.map(value => value),
        solutionStackName.map(value => value),
        platformArn.map(value => value),
        optionSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        optionsToRemove.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        operationsRole.map(value => value)
      )
    def applicationName: ApplicationName
    def environmentName: Option[EnvironmentName]
    def groupName: Option[GroupName]
    def description: Option[Description]
    def cnamePrefix: Option[DNSCnamePrefix]
    def tier: Option[zio.aws.elasticbeanstalk.model.EnvironmentTier.ReadOnly]
    def tags: Option[List[zio.aws.elasticbeanstalk.model.Tag.ReadOnly]]
    def versionLabel: Option[VersionLabel]
    def templateName: Option[ConfigurationTemplateName]
    def solutionStackName: Option[SolutionStackName]
    def platformArn: Option[PlatformArn]
    def optionSettings: Option[
      List[zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly]
    ]
    def optionsToRemove: Option[
      List[zio.aws.elasticbeanstalk.model.OptionSpecification.ReadOnly]
    ]
    def operationsRole: Option[OperationsRole]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getGroupName: ZIO[Any, AwsError, GroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCnamePrefix: ZIO[Any, AwsError, DNSCnamePrefix] =
      AwsError.unwrapOptionField("cnamePrefix", cnamePrefix)
    def getTier: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.EnvironmentTier.ReadOnly
    ] = AwsError.unwrapOptionField("tier", tier)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getVersionLabel: ZIO[Any, AwsError, VersionLabel] =
      AwsError.unwrapOptionField("versionLabel", versionLabel)
    def getTemplateName: ZIO[Any, AwsError, ConfigurationTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getSolutionStackName: ZIO[Any, AwsError, SolutionStackName] =
      AwsError.unwrapOptionField("solutionStackName", solutionStackName)
    def getPlatformArn: ZIO[Any, AwsError, PlatformArn] =
      AwsError.unwrapOptionField("platformArn", platformArn)
    def getOptionSettings: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("optionSettings", optionSettings)
    def getOptionsToRemove: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.OptionSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("optionsToRemove", optionsToRemove)
    def getOperationsRole: ZIO[Any, AwsError, OperationsRole] =
      AwsError.unwrapOptionField("operationsRole", operationsRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CreateEnvironmentRequest
  ) extends zio.aws.elasticbeanstalk.model.CreateEnvironmentRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.elasticbeanstalk.model.primitives
        .ApplicationName(impl.applicationName())
    override val environmentName: Option[EnvironmentName] = scala
      .Option(impl.environmentName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
      )
    override val groupName: Option[GroupName] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.GroupName(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.Description(value)
      )
    override val cnamePrefix: Option[DNSCnamePrefix] = scala
      .Option(impl.cnamePrefix())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.DNSCnamePrefix(value)
      )
    override val tier
        : Option[zio.aws.elasticbeanstalk.model.EnvironmentTier.ReadOnly] =
      scala
        .Option(impl.tier())
        .map(value =>
          zio.aws.elasticbeanstalk.model.EnvironmentTier.wrap(value)
        )
    override val tags
        : Option[List[zio.aws.elasticbeanstalk.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.Tag.wrap(item)
        }.toList
      )
    override val versionLabel: Option[VersionLabel] = scala
      .Option(impl.versionLabel())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.VersionLabel(value)
      )
    override val templateName: Option[ConfigurationTemplateName] = scala
      .Option(impl.templateName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives
          .ConfigurationTemplateName(value)
      )
    override val solutionStackName: Option[SolutionStackName] = scala
      .Option(impl.solutionStackName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.SolutionStackName(value)
      )
    override val platformArn: Option[PlatformArn] = scala
      .Option(impl.platformArn())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformArn(value)
      )
    override val optionSettings: Option[
      List[zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly]
    ] = scala
      .Option(impl.optionSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.wrap(item)
        }.toList
      )
    override val optionsToRemove: Option[
      List[zio.aws.elasticbeanstalk.model.OptionSpecification.ReadOnly]
    ] = scala
      .Option(impl.optionsToRemove())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.OptionSpecification.wrap(item)
        }.toList
      )
    override val operationsRole: Option[OperationsRole] = scala
      .Option(impl.operationsRole())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.OperationsRole(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CreateEnvironmentRequest
  ): zio.aws.elasticbeanstalk.model.CreateEnvironmentRequest.ReadOnly =
    new Wrapper(impl)
}
