package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.SolutionStackName
import scala.jdk.CollectionConverters._
final case class ListAvailableSolutionStacksResponse(
    solutionStacks: Option[Iterable[SolutionStackName]] = None,
    solutionStackDetails: Option[
      Iterable[zio.aws.elasticbeanstalk.model.SolutionStackDescription]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ListAvailableSolutionStacksResponse = {
    import ListAvailableSolutionStacksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ListAvailableSolutionStacksResponse
      .builder()
      .optionallyWith(
        solutionStacks.map(value =>
          value.map { item =>
            SolutionStackName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.solutionStacks)
      .optionallyWith(
        solutionStackDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.solutionStackDetails)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ListAvailableSolutionStacksResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.ListAvailableSolutionStacksResponse
      .wrap(buildAwsValue())
}
object ListAvailableSolutionStacksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ListAvailableSolutionStacksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.ListAvailableSolutionStacksResponse =
      zio.aws.elasticbeanstalk.model.ListAvailableSolutionStacksResponse(
        solutionStacks.map(value => value),
        solutionStackDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def solutionStacks: Option[List[SolutionStackName]]
    def solutionStackDetails: Option[
      List[zio.aws.elasticbeanstalk.model.SolutionStackDescription.ReadOnly]
    ]
    def getSolutionStacks: ZIO[Any, AwsError, List[SolutionStackName]] =
      AwsError.unwrapOptionField("solutionStacks", solutionStacks)
    def getSolutionStackDetails: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.SolutionStackDescription.ReadOnly
    ]] =
      AwsError.unwrapOptionField("solutionStackDetails", solutionStackDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ListAvailableSolutionStacksResponse
  ) extends zio.aws.elasticbeanstalk.model.ListAvailableSolutionStacksResponse.ReadOnly {
    override val solutionStacks: Option[List[SolutionStackName]] = scala
      .Option(impl.solutionStacks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.primitives.SolutionStackName(item)
        }.toList
      )
    override val solutionStackDetails: Option[
      List[zio.aws.elasticbeanstalk.model.SolutionStackDescription.ReadOnly]
    ] = scala
      .Option(impl.solutionStackDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.SolutionStackDescription.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ListAvailableSolutionStacksResponse
  ): zio.aws.elasticbeanstalk.model.ListAvailableSolutionStacksResponse.ReadOnly =
    new Wrapper(impl)
}
