package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeEnvironmentManagedActionsResponse(
    managedActions: Option[
      Iterable[zio.aws.elasticbeanstalk.model.ManagedAction]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsResponse = {
    import DescribeEnvironmentManagedActionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsResponse
      .builder()
      .optionallyWith(
        managedActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.managedActions)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionsResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionsResponse
      .wrap(buildAwsValue())
}
object DescribeEnvironmentManagedActionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionsResponse =
      zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionsResponse(
        managedActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def managedActions
        : Option[List[zio.aws.elasticbeanstalk.model.ManagedAction.ReadOnly]]
    def getManagedActions: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.ManagedAction.ReadOnly
    ]] = AwsError.unwrapOptionField("managedActions", managedActions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsResponse
  ) extends zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionsResponse.ReadOnly {
    override val managedActions
        : Option[List[zio.aws.elasticbeanstalk.model.ManagedAction.ReadOnly]] =
      scala
        .Option(impl.managedActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.ManagedAction.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsResponse
  ): zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionsResponse.ReadOnly =
    new Wrapper(impl)
}
