package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateApplicationResponse(
    application: Option[zio.aws.elasticbeanstalk.model.ApplicationDescription] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResponse = {
    import UpdateApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResponse
      .builder()
      .optionallyWith(application.map(value => value.buildAwsValue()))(
        _.application
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.UpdateApplicationResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.UpdateApplicationResponse
      .wrap(buildAwsValue())
}
object UpdateApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.UpdateApplicationResponse =
      zio.aws.elasticbeanstalk.model
        .UpdateApplicationResponse(application.map(value => value.asEditable))
    def application
        : Option[zio.aws.elasticbeanstalk.model.ApplicationDescription.ReadOnly]
    def getApplication: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ApplicationDescription.ReadOnly
    ] = AwsError.unwrapOptionField("application", application)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResponse
  ) extends zio.aws.elasticbeanstalk.model.UpdateApplicationResponse.ReadOnly {
    override val application: Option[
      zio.aws.elasticbeanstalk.model.ApplicationDescription.ReadOnly
    ] = scala
      .Option(impl.application())
      .map(value =>
        zio.aws.elasticbeanstalk.model.ApplicationDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResponse
  ): zio.aws.elasticbeanstalk.model.UpdateApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
