package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{ImageId, VirtualizationType}
import scala.jdk.CollectionConverters._
final case class CustomAmi(
    virtualizationType: Option[VirtualizationType] = None,
    imageId: Option[ImageId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.CustomAmi = {
    import CustomAmi.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.CustomAmi
      .builder()
      .optionallyWith(
        virtualizationType.map(value =>
          VirtualizationType.unwrap(value): java.lang.String
        )
      )(_.virtualizationType)
      .optionallyWith(
        imageId.map(value => ImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.CustomAmi.ReadOnly =
    zio.aws.elasticbeanstalk.model.CustomAmi.wrap(buildAwsValue())
}
object CustomAmi {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.CustomAmi
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.CustomAmi =
      zio.aws.elasticbeanstalk.model.CustomAmi(
        virtualizationType.map(value => value),
        imageId.map(value => value)
      )
    def virtualizationType: Option[VirtualizationType]
    def imageId: Option[ImageId]
    def getVirtualizationType: ZIO[Any, AwsError, VirtualizationType] =
      AwsError.unwrapOptionField("virtualizationType", virtualizationType)
    def getImageId: ZIO[Any, AwsError, ImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CustomAmi
  ) extends zio.aws.elasticbeanstalk.model.CustomAmi.ReadOnly {
    override val virtualizationType: Option[VirtualizationType] = scala
      .Option(impl.virtualizationType())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.VirtualizationType(value)
      )
    override val imageId: Option[ImageId] = scala
      .Option(impl.imageId())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.ImageId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CustomAmi
  ): zio.aws.elasticbeanstalk.model.CustomAmi.ReadOnly = new Wrapper(impl)
}
