package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{
  ConfigurationTemplateName,
  ApplicationName,
  EnvironmentName,
  SolutionStackName,
  PlatformArn
}
import scala.jdk.CollectionConverters._
final case class DescribeConfigurationOptionsRequest(
    applicationName: Option[ApplicationName] = None,
    templateName: Option[ConfigurationTemplateName] = None,
    environmentName: Option[EnvironmentName] = None,
    solutionStackName: Option[SolutionStackName] = None,
    platformArn: Option[PlatformArn] = None,
    options: Option[
      Iterable[zio.aws.elasticbeanstalk.model.OptionSpecification]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest = {
    import DescribeConfigurationOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest
      .builder()
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        templateName.map(value =>
          ConfigurationTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(
        solutionStackName.map(value =>
          SolutionStackName.unwrap(value): java.lang.String
        )
      )(_.solutionStackName)
      .optionallyWith(
        platformArn.map(value => PlatformArn.unwrap(value): java.lang.String)
      )(_.platformArn)
      .optionallyWith(
        options.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.options)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeConfigurationOptionsRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeConfigurationOptionsRequest
      .wrap(buildAwsValue())
}
object DescribeConfigurationOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DescribeConfigurationOptionsRequest =
      zio.aws.elasticbeanstalk.model.DescribeConfigurationOptionsRequest(
        applicationName.map(value => value),
        templateName.map(value => value),
        environmentName.map(value => value),
        solutionStackName.map(value => value),
        platformArn.map(value => value),
        options.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def applicationName: Option[ApplicationName]
    def templateName: Option[ConfigurationTemplateName]
    def environmentName: Option[EnvironmentName]
    def solutionStackName: Option[SolutionStackName]
    def platformArn: Option[PlatformArn]
    def options: Option[
      List[zio.aws.elasticbeanstalk.model.OptionSpecification.ReadOnly]
    ]
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getTemplateName: ZIO[Any, AwsError, ConfigurationTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getSolutionStackName: ZIO[Any, AwsError, SolutionStackName] =
      AwsError.unwrapOptionField("solutionStackName", solutionStackName)
    def getPlatformArn: ZIO[Any, AwsError, PlatformArn] =
      AwsError.unwrapOptionField("platformArn", platformArn)
    def getOptions: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.OptionSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("options", options)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest
  ) extends zio.aws.elasticbeanstalk.model.DescribeConfigurationOptionsRequest.ReadOnly {
    override val applicationName: Option[ApplicationName] = scala
      .Option(impl.applicationName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.ApplicationName(value)
      )
    override val templateName: Option[ConfigurationTemplateName] = scala
      .Option(impl.templateName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives
          .ConfigurationTemplateName(value)
      )
    override val environmentName: Option[EnvironmentName] = scala
      .Option(impl.environmentName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
      )
    override val solutionStackName: Option[SolutionStackName] = scala
      .Option(impl.solutionStackName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.SolutionStackName(value)
      )
    override val platformArn: Option[PlatformArn] = scala
      .Option(impl.platformArn())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformArn(value)
      )
    override val options: Option[
      List[zio.aws.elasticbeanstalk.model.OptionSpecification.ReadOnly]
    ] = scala
      .Option(impl.options())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.OptionSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest
  ): zio.aws.elasticbeanstalk.model.DescribeConfigurationOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
