package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeEnvironmentManagedActionsRequest(
    environmentName: Option[String] = None,
    environmentId: Option[String] = None,
    status: Option[zio.aws.elasticbeanstalk.model.ActionStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest = {
    import DescribeEnvironmentManagedActionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest
      .builder()
      .optionallyWith(environmentName.map(value => value: java.lang.String))(
        _.environmentName
      )
      .optionallyWith(environmentId.map(value => value: java.lang.String))(
        _.environmentId
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest
      .wrap(buildAwsValue())
}
object DescribeEnvironmentManagedActionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest =
      zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest(
        environmentName.map(value => value),
        environmentId.map(value => value),
        status.map(value => value)
      )
    def environmentName: Option[String]
    def environmentId: Option[String]
    def status: Option[zio.aws.elasticbeanstalk.model.ActionStatus]
    def getEnvironmentName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getEnvironmentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.elasticbeanstalk.model.ActionStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest
  ) extends zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest.ReadOnly {
    override val environmentName: Option[String] =
      scala.Option(impl.environmentName()).map(value => value: String)
    override val environmentId: Option[String] =
      scala.Option(impl.environmentId()).map(value => value: String)
    override val status: Option[zio.aws.elasticbeanstalk.model.ActionStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.elasticbeanstalk.model.ActionStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest
  ): zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest.ReadOnly =
    new Wrapper(impl)
}
