package zio.aws.elasticbeanstalk.model
import scala.jdk.CollectionConverters._
sealed trait ComputeType {
  def unwrap: software.amazon.awssdk.services.elasticbeanstalk.model.ComputeType
}
object ComputeType {
  def wrap(
      value: software.amazon.awssdk.services.elasticbeanstalk.model.ComputeType
  ): zio.aws.elasticbeanstalk.model.ComputeType = value match {
    case software.amazon.awssdk.services.elasticbeanstalk.model.ComputeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.ComputeType.BUILD_GENERAL1_SMALL =>
      val r = BUILD_GENERAL1_SMALL
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.ComputeType.BUILD_GENERAL1_MEDIUM =>
      val r = BUILD_GENERAL1_MEDIUM
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.ComputeType.BUILD_GENERAL1_LARGE =>
      val r = BUILD_GENERAL1_LARGE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticbeanstalk.model.ComputeType {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ComputeType =
      software.amazon.awssdk.services.elasticbeanstalk.model.ComputeType.UNKNOWN_TO_SDK_VERSION
  }
  case object BUILD_GENERAL1_SMALL
      extends zio.aws.elasticbeanstalk.model.ComputeType {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ComputeType =
      software.amazon.awssdk.services.elasticbeanstalk.model.ComputeType.BUILD_GENERAL1_SMALL
  }
  case object BUILD_GENERAL1_MEDIUM
      extends zio.aws.elasticbeanstalk.model.ComputeType {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ComputeType =
      software.amazon.awssdk.services.elasticbeanstalk.model.ComputeType.BUILD_GENERAL1_MEDIUM
  }
  case object BUILD_GENERAL1_LARGE
      extends zio.aws.elasticbeanstalk.model.ComputeType {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ComputeType =
      software.amazon.awssdk.services.elasticbeanstalk.model.ComputeType.BUILD_GENERAL1_LARGE
  }
}
