package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elasticbeanstalk.model.primitives.DNSCnamePrefix
import scala.jdk.CollectionConverters._
final case class CheckDnsAvailabilityRequest(cnamePrefix: DNSCnamePrefix) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.CheckDnsAvailabilityRequest = {
    import CheckDnsAvailabilityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.CheckDnsAvailabilityRequest
      .builder()
      .cnamePrefix(DNSCnamePrefix.unwrap(cnamePrefix): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.CheckDnsAvailabilityRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.CheckDnsAvailabilityRequest
      .wrap(buildAwsValue())
}
object CheckDnsAvailabilityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.CheckDnsAvailabilityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.CheckDnsAvailabilityRequest =
      zio.aws.elasticbeanstalk.model.CheckDnsAvailabilityRequest(cnamePrefix)
    def cnamePrefix: DNSCnamePrefix
    def getCnamePrefix: ZIO[Any, Nothing, DNSCnamePrefix] =
      ZIO.succeed(cnamePrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CheckDnsAvailabilityRequest
  ) extends zio.aws.elasticbeanstalk.model.CheckDnsAvailabilityRequest.ReadOnly {
    override val cnamePrefix: DNSCnamePrefix =
      zio.aws.elasticbeanstalk.model.primitives
        .DNSCnamePrefix(impl.cnamePrefix())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CheckDnsAvailabilityRequest
  ): zio.aws.elasticbeanstalk.model.CheckDnsAvailabilityRequest.ReadOnly =
    new Wrapper(impl)
}
