package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.{Description, ApplicationName}
import scala.jdk.CollectionConverters._
final case class CreateApplicationRequest(
    applicationName: ApplicationName,
    description: Optional[Description] = Optional.Absent,
    resourceLifecycleConfig: Optional[
      zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.elasticbeanstalk.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationRequest = {
    import CreateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        resourceLifecycleConfig.map(value => value.buildAwsValue())
      )(_.resourceLifecycleConfig)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.CreateApplicationRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.CreateApplicationRequest
      .wrap(buildAwsValue())
}
object CreateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.CreateApplicationRequest =
      zio.aws.elasticbeanstalk.model.CreateApplicationRequest(
        applicationName,
        description.map(value => value),
        resourceLifecycleConfig.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def applicationName: ApplicationName
    def description: Optional[Description]
    def resourceLifecycleConfig: Optional[
      zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig.ReadOnly
    ]
    def tags: Optional[List[zio.aws.elasticbeanstalk.model.Tag.ReadOnly]]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getResourceLifecycleConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resourceLifecycleConfig",
      resourceLifecycleConfig
    )
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationRequest
  ) extends zio.aws.elasticbeanstalk.model.CreateApplicationRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.elasticbeanstalk.model.primitives
        .ApplicationName(impl.applicationName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.Description(value)
      )
    override val resourceLifecycleConfig: Optional[
      zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceLifecycleConfig())
      .map(value =>
        zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig
          .wrap(value)
      )
    override val tags
        : Optional[List[zio.aws.elasticbeanstalk.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationRequest
  ): zio.aws.elasticbeanstalk.model.CreateApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
