package zio.aws.elasticbeanstalk.model
import zio.aws.elasticbeanstalk.model.primitives.{LaunchedAt, Cause, InstanceId}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class SingleInstanceHealth(
    instanceId: Optional[InstanceId] = Optional.Absent,
    healthStatus: Optional[String] = Optional.Absent,
    color: Optional[String] = Optional.Absent,
    causes: Optional[Iterable[Cause]] = Optional.Absent,
    launchedAt: Optional[LaunchedAt] = Optional.Absent,
    applicationMetrics: Optional[
      zio.aws.elasticbeanstalk.model.ApplicationMetrics
    ] = Optional.Absent,
    system: Optional[zio.aws.elasticbeanstalk.model.SystemStatus] =
      Optional.Absent,
    deployment: Optional[zio.aws.elasticbeanstalk.model.Deployment] =
      Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    instanceType: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.SingleInstanceHealth = {
    import SingleInstanceHealth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.SingleInstanceHealth
      .builder()
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(healthStatus.map(value => value: java.lang.String))(
        _.healthStatus
      )
      .optionallyWith(color.map(value => value: java.lang.String))(_.color)
      .optionallyWith(
        causes.map(value =>
          value.map { item =>
            Cause.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.causes)
      .optionallyWith(
        launchedAt.map(value => LaunchedAt.unwrap(value): Instant)
      )(_.launchedAt)
      .optionallyWith(applicationMetrics.map(value => value.buildAwsValue()))(
        _.applicationMetrics
      )
      .optionallyWith(system.map(value => value.buildAwsValue()))(_.system)
      .optionallyWith(deployment.map(value => value.buildAwsValue()))(
        _.deployment
      )
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.SingleInstanceHealth.ReadOnly =
    zio.aws.elasticbeanstalk.model.SingleInstanceHealth.wrap(buildAwsValue())
}
object SingleInstanceHealth {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.SingleInstanceHealth
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.SingleInstanceHealth =
      zio.aws.elasticbeanstalk.model.SingleInstanceHealth(
        instanceId.map(value => value),
        healthStatus.map(value => value),
        color.map(value => value),
        causes.map(value => value),
        launchedAt.map(value => value),
        applicationMetrics.map(value => value.asEditable),
        system.map(value => value.asEditable),
        deployment.map(value => value.asEditable),
        availabilityZone.map(value => value),
        instanceType.map(value => value)
      )
    def instanceId: Optional[InstanceId]
    def healthStatus: Optional[String]
    def color: Optional[String]
    def causes: Optional[List[Cause]]
    def launchedAt: Optional[LaunchedAt]
    def applicationMetrics
        : Optional[zio.aws.elasticbeanstalk.model.ApplicationMetrics.ReadOnly]
    def system: Optional[zio.aws.elasticbeanstalk.model.SystemStatus.ReadOnly]
    def deployment: Optional[zio.aws.elasticbeanstalk.model.Deployment.ReadOnly]
    def availabilityZone: Optional[String]
    def instanceType: Optional[String]
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getHealthStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("healthStatus", healthStatus)
    def getColor: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("color", color)
    def getCauses: ZIO[Any, AwsError, List[Cause]] =
      AwsError.unwrapOptionField("causes", causes)
    def getLaunchedAt: ZIO[Any, AwsError, LaunchedAt] =
      AwsError.unwrapOptionField("launchedAt", launchedAt)
    def getApplicationMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ApplicationMetrics.ReadOnly
    ] = AwsError.unwrapOptionField("applicationMetrics", applicationMetrics)
    def getSystem: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.SystemStatus.ReadOnly
    ] = AwsError.unwrapOptionField("system", system)
    def getDeployment: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.Deployment.ReadOnly
    ] = AwsError.unwrapOptionField("deployment", deployment)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.SingleInstanceHealth
  ) extends zio.aws.elasticbeanstalk.model.SingleInstanceHealth.ReadOnly {
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.InstanceId(value))
    override val healthStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.healthStatus())
      .map(value => value: String)
    override val color: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.color())
      .map(value => value: String)
    override val causes: Optional[List[Cause]] = zio.aws.core.internal
      .optionalFromNullable(impl.causes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.primitives.Cause(item)
        }.toList
      )
    override val launchedAt: Optional[LaunchedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.launchedAt())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.LaunchedAt(value))
    override val applicationMetrics
        : Optional[zio.aws.elasticbeanstalk.model.ApplicationMetrics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationMetrics())
        .map(value =>
          zio.aws.elasticbeanstalk.model.ApplicationMetrics.wrap(value)
        )
    override val system
        : Optional[zio.aws.elasticbeanstalk.model.SystemStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.system())
        .map(value => zio.aws.elasticbeanstalk.model.SystemStatus.wrap(value))
    override val deployment
        : Optional[zio.aws.elasticbeanstalk.model.Deployment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deployment())
        .map(value => zio.aws.elasticbeanstalk.model.Deployment.wrap(value))
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.SingleInstanceHealth
  ): zio.aws.elasticbeanstalk.model.SingleInstanceHealth.ReadOnly = new Wrapper(
    impl
  )
}
