package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RetrieveEnvironmentInfoResponse(
    environmentInfo: Optional[
      Iterable[zio.aws.elasticbeanstalk.model.EnvironmentInfoDescription]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.RetrieveEnvironmentInfoResponse = {
    import RetrieveEnvironmentInfoResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.RetrieveEnvironmentInfoResponse
      .builder()
      .optionallyWith(
        environmentInfo.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environmentInfo)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.RetrieveEnvironmentInfoResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.RetrieveEnvironmentInfoResponse
      .wrap(buildAwsValue())
}
object RetrieveEnvironmentInfoResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.RetrieveEnvironmentInfoResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.RetrieveEnvironmentInfoResponse =
      zio.aws.elasticbeanstalk.model.RetrieveEnvironmentInfoResponse(
        environmentInfo.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def environmentInfo: Optional[
      List[zio.aws.elasticbeanstalk.model.EnvironmentInfoDescription.ReadOnly]
    ]
    def getEnvironmentInfo: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.EnvironmentInfoDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("environmentInfo", environmentInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.RetrieveEnvironmentInfoResponse
  ) extends zio.aws.elasticbeanstalk.model.RetrieveEnvironmentInfoResponse.ReadOnly {
    override val environmentInfo: Optional[
      List[zio.aws.elasticbeanstalk.model.EnvironmentInfoDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentInfo())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.EnvironmentInfoDescription.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.RetrieveEnvironmentInfoResponse
  ): zio.aws.elasticbeanstalk.model.RetrieveEnvironmentInfoResponse.ReadOnly =
    new Wrapper(impl)
}
