package zio.aws.elasticbeanstalk.model
import zio.aws.elasticbeanstalk.model.primitives.NullableInteger
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class StatusCodes(
    status2xx: Optional[NullableInteger] = Optional.Absent,
    status3xx: Optional[NullableInteger] = Optional.Absent,
    status4xx: Optional[NullableInteger] = Optional.Absent,
    status5xx: Optional[NullableInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.StatusCodes = {
    import StatusCodes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.StatusCodes
      .builder()
      .optionallyWith(status2xx.map(value => value: Integer))(_.status2xx)
      .optionallyWith(status3xx.map(value => value: Integer))(_.status3xx)
      .optionallyWith(status4xx.map(value => value: Integer))(_.status4xx)
      .optionallyWith(status5xx.map(value => value: Integer))(_.status5xx)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.StatusCodes.ReadOnly =
    zio.aws.elasticbeanstalk.model.StatusCodes.wrap(buildAwsValue())
}
object StatusCodes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.StatusCodes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.StatusCodes =
      zio.aws.elasticbeanstalk.model.StatusCodes(
        status2xx.map(value => value),
        status3xx.map(value => value),
        status4xx.map(value => value),
        status5xx.map(value => value)
      )
    def status2xx: Optional[NullableInteger]
    def status3xx: Optional[NullableInteger]
    def status4xx: Optional[NullableInteger]
    def status5xx: Optional[NullableInteger]
    def getStatus2xx: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("status2xx", status2xx)
    def getStatus3xx: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("status3xx", status3xx)
    def getStatus4xx: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("status4xx", status4xx)
    def getStatus5xx: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("status5xx", status5xx)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.StatusCodes
  ) extends zio.aws.elasticbeanstalk.model.StatusCodes.ReadOnly {
    override val status2xx: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.status2xx())
      .map(value => value: NullableInteger)
    override val status3xx: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.status3xx())
      .map(value => value: NullableInteger)
    override val status4xx: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.status4xx())
      .map(value => value: NullableInteger)
    override val status5xx: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.status5xx())
      .map(value => value: NullableInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.StatusCodes
  ): zio.aws.elasticbeanstalk.model.StatusCodes.ReadOnly = new Wrapper(impl)
}
