package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEnvironmentManagedActionHistoryResponse(
    managedActionHistoryItems: Optional[
      Iterable[zio.aws.elasticbeanstalk.model.ManagedActionHistoryItem]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse = {
    import DescribeEnvironmentManagedActionHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse
      .builder()
      .optionallyWith(
        managedActionHistoryItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.managedActionHistoryItems)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse
      .wrap(buildAwsValue())
}
object DescribeEnvironmentManagedActionHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse =
      zio.aws.elasticbeanstalk.model
        .DescribeEnvironmentManagedActionHistoryResponse(
          managedActionHistoryItems.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def managedActionHistoryItems: Optional[
      List[zio.aws.elasticbeanstalk.model.ManagedActionHistoryItem.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getManagedActionHistoryItems: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.ManagedActionHistoryItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "managedActionHistoryItems",
      managedActionHistoryItems
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse
  ) extends zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse.ReadOnly {
    override val managedActionHistoryItems: Optional[
      List[zio.aws.elasticbeanstalk.model.ManagedActionHistoryItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.managedActionHistoryItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.ManagedActionHistoryItem.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse
  ): zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse.ReadOnly =
    new Wrapper(impl)
}
