package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeletePlatformVersionResponse(
    platformSummary: Optional[zio.aws.elasticbeanstalk.model.PlatformSummary] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DeletePlatformVersionResponse = {
    import DeletePlatformVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DeletePlatformVersionResponse
      .builder()
      .optionallyWith(platformSummary.map(value => value.buildAwsValue()))(
        _.platformSummary
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DeletePlatformVersionResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.DeletePlatformVersionResponse
      .wrap(buildAwsValue())
}
object DeletePlatformVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DeletePlatformVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DeletePlatformVersionResponse =
      zio.aws.elasticbeanstalk.model.DeletePlatformVersionResponse(
        platformSummary.map(value => value.asEditable)
      )
    def platformSummary
        : Optional[zio.aws.elasticbeanstalk.model.PlatformSummary.ReadOnly]
    def getPlatformSummary: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.PlatformSummary.ReadOnly
    ] = AwsError.unwrapOptionField("platformSummary", platformSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DeletePlatformVersionResponse
  ) extends zio.aws.elasticbeanstalk.model.DeletePlatformVersionResponse.ReadOnly {
    override val platformSummary
        : Optional[zio.aws.elasticbeanstalk.model.PlatformSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformSummary())
        .map(value =>
          zio.aws.elasticbeanstalk.model.PlatformSummary.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DeletePlatformVersionResponse
  ): zio.aws.elasticbeanstalk.model.DeletePlatformVersionResponse.ReadOnly =
    new Wrapper(impl)
}
