package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elasticbeanstalk.model.primitives.EnvironmentName
import scala.jdk.CollectionConverters._
final case class DisassociateEnvironmentOperationsRoleRequest(
    environmentName: EnvironmentName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DisassociateEnvironmentOperationsRoleRequest = {
    import DisassociateEnvironmentOperationsRoleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DisassociateEnvironmentOperationsRoleRequest
      .builder()
      .environmentName(
        EnvironmentName.unwrap(environmentName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DisassociateEnvironmentOperationsRoleRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.DisassociateEnvironmentOperationsRoleRequest
      .wrap(buildAwsValue())
}
object DisassociateEnvironmentOperationsRoleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DisassociateEnvironmentOperationsRoleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DisassociateEnvironmentOperationsRoleRequest =
      zio.aws.elasticbeanstalk.model
        .DisassociateEnvironmentOperationsRoleRequest(environmentName)
    def environmentName: EnvironmentName
    def getEnvironmentName: ZIO[Any, Nothing, EnvironmentName] =
      ZIO.succeed(environmentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DisassociateEnvironmentOperationsRoleRequest
  ) extends zio.aws.elasticbeanstalk.model.DisassociateEnvironmentOperationsRoleRequest.ReadOnly {
    override val environmentName: EnvironmentName =
      zio.aws.elasticbeanstalk.model.primitives
        .EnvironmentName(impl.environmentName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DisassociateEnvironmentOperationsRoleRequest
  ): zio.aws.elasticbeanstalk.model.DisassociateEnvironmentOperationsRoleRequest.ReadOnly =
    new Wrapper(impl)
}
