package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.{
  EnvironmentName,
  ConfigurationTemplateName,
  ApplicationName
}
import scala.jdk.CollectionConverters._
final case class DescribeConfigurationSettingsRequest(
    applicationName: ApplicationName,
    templateName: Optional[ConfigurationTemplateName] = Optional.Absent,
    environmentName: Optional[EnvironmentName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest = {
    import DescribeConfigurationSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(
        templateName.map(value =>
          ConfigurationTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeConfigurationSettingsRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeConfigurationSettingsRequest
      .wrap(buildAwsValue())
}
object DescribeConfigurationSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DescribeConfigurationSettingsRequest =
      zio.aws.elasticbeanstalk.model.DescribeConfigurationSettingsRequest(
        applicationName,
        templateName.map(value => value),
        environmentName.map(value => value)
      )
    def applicationName: ApplicationName
    def templateName: Optional[ConfigurationTemplateName]
    def environmentName: Optional[EnvironmentName]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getTemplateName: ZIO[Any, AwsError, ConfigurationTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest
  ) extends zio.aws.elasticbeanstalk.model.DescribeConfigurationSettingsRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.elasticbeanstalk.model.primitives
        .ApplicationName(impl.applicationName())
    override val templateName: Optional[ConfigurationTemplateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives
            .ConfigurationTemplateName(value)
        )
    override val environmentName: Optional[EnvironmentName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest
  ): zio.aws.elasticbeanstalk.model.DescribeConfigurationSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
