package zio.aws.elasticbeanstalk.model
import zio.aws.elasticbeanstalk.model.primitives.{Token, PlatformMaxRecords}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPlatformVersionsRequest(
    filters: Optional[Iterable[zio.aws.elasticbeanstalk.model.PlatformFilter]] =
      Optional.Absent,
    maxRecords: Optional[PlatformMaxRecords] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest = {
    import ListPlatformVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxRecords.map(value => PlatformMaxRecords.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ListPlatformVersionsRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.ListPlatformVersionsRequest
      .wrap(buildAwsValue())
}
object ListPlatformVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.ListPlatformVersionsRequest =
      zio.aws.elasticbeanstalk.model.ListPlatformVersionsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        nextToken.map(value => value)
      )
    def filters
        : Optional[List[zio.aws.elasticbeanstalk.model.PlatformFilter.ReadOnly]]
    def maxRecords: Optional[PlatformMaxRecords]
    def nextToken: Optional[Token]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.PlatformFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, PlatformMaxRecords] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest
  ) extends zio.aws.elasticbeanstalk.model.ListPlatformVersionsRequest.ReadOnly {
    override val filters: Optional[
      List[zio.aws.elasticbeanstalk.model.PlatformFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.PlatformFilter.wrap(item)
        }.toList
      )
    override val maxRecords: Optional[PlatformMaxRecords] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxRecords())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.PlatformMaxRecords(value)
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest
  ): zio.aws.elasticbeanstalk.model.ListPlatformVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
