package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeConfigurationSettingsResponse(
    configurationSettings: Optional[
      Iterable[zio.aws.elasticbeanstalk.model.ConfigurationSettingsDescription]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsResponse = {
    import DescribeConfigurationSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsResponse
      .builder()
      .optionallyWith(
        configurationSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configurationSettings)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeConfigurationSettingsResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeConfigurationSettingsResponse
      .wrap(buildAwsValue())
}
object DescribeConfigurationSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DescribeConfigurationSettingsResponse =
      zio.aws.elasticbeanstalk.model.DescribeConfigurationSettingsResponse(
        configurationSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def configurationSettings: Optional[List[
      zio.aws.elasticbeanstalk.model.ConfigurationSettingsDescription.ReadOnly
    ]]
    def getConfigurationSettings: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.ConfigurationSettingsDescription.ReadOnly
    ]] =
      AwsError.unwrapOptionField("configurationSettings", configurationSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsResponse
  ) extends zio.aws.elasticbeanstalk.model.DescribeConfigurationSettingsResponse.ReadOnly {
    override val configurationSettings: Optional[List[
      zio.aws.elasticbeanstalk.model.ConfigurationSettingsDescription.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.ConfigurationSettingsDescription
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsResponse
  ): zio.aws.elasticbeanstalk.model.DescribeConfigurationSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
