package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.EnvironmentName
import scala.jdk.CollectionConverters._
final case class EnvironmentResourceDescription(
    environmentName: Optional[EnvironmentName] = Optional.Absent,
    autoScalingGroups: Optional[
      Iterable[zio.aws.elasticbeanstalk.model.AutoScalingGroup]
    ] = Optional.Absent,
    instances: Optional[Iterable[zio.aws.elasticbeanstalk.model.Instance]] =
      Optional.Absent,
    launchConfigurations: Optional[
      Iterable[zio.aws.elasticbeanstalk.model.LaunchConfiguration]
    ] = Optional.Absent,
    launchTemplates: Optional[
      Iterable[zio.aws.elasticbeanstalk.model.LaunchTemplate]
    ] = Optional.Absent,
    loadBalancers: Optional[
      Iterable[zio.aws.elasticbeanstalk.model.LoadBalancer]
    ] = Optional.Absent,
    triggers: Optional[Iterable[zio.aws.elasticbeanstalk.model.Trigger]] =
      Optional.Absent,
    queues: Optional[Iterable[zio.aws.elasticbeanstalk.model.Queue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentResourceDescription = {
    import EnvironmentResourceDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentResourceDescription
      .builder()
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(
        autoScalingGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.autoScalingGroups)
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .optionallyWith(
        launchConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.launchConfigurations)
      .optionallyWith(
        launchTemplates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.launchTemplates)
      .optionallyWith(
        loadBalancers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loadBalancers)
      .optionallyWith(
        triggers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.triggers)
      .optionallyWith(
        queues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.queues)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.EnvironmentResourceDescription.ReadOnly =
    zio.aws.elasticbeanstalk.model.EnvironmentResourceDescription
      .wrap(buildAwsValue())
}
object EnvironmentResourceDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentResourceDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.EnvironmentResourceDescription =
      zio.aws.elasticbeanstalk.model.EnvironmentResourceDescription(
        environmentName.map(value => value),
        autoScalingGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        launchConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        launchTemplates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        loadBalancers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        triggers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        queues.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def environmentName: Optional[EnvironmentName]
    def autoScalingGroups: Optional[
      List[zio.aws.elasticbeanstalk.model.AutoScalingGroup.ReadOnly]
    ]
    def instances
        : Optional[List[zio.aws.elasticbeanstalk.model.Instance.ReadOnly]]
    def launchConfigurations: Optional[
      List[zio.aws.elasticbeanstalk.model.LaunchConfiguration.ReadOnly]
    ]
    def launchTemplates
        : Optional[List[zio.aws.elasticbeanstalk.model.LaunchTemplate.ReadOnly]]
    def loadBalancers
        : Optional[List[zio.aws.elasticbeanstalk.model.LoadBalancer.ReadOnly]]
    def triggers
        : Optional[List[zio.aws.elasticbeanstalk.model.Trigger.ReadOnly]]
    def queues: Optional[List[zio.aws.elasticbeanstalk.model.Queue.ReadOnly]]
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getAutoScalingGroups: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.AutoScalingGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("autoScalingGroups", autoScalingGroups)
    def getInstances: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.Instance.ReadOnly
    ]] = AwsError.unwrapOptionField("instances", instances)
    def getLaunchConfigurations: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.LaunchConfiguration.ReadOnly
    ]] =
      AwsError.unwrapOptionField("launchConfigurations", launchConfigurations)
    def getLaunchTemplates: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.LaunchTemplate.ReadOnly
    ]] = AwsError.unwrapOptionField("launchTemplates", launchTemplates)
    def getLoadBalancers: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.LoadBalancer.ReadOnly
    ]] = AwsError.unwrapOptionField("loadBalancers", loadBalancers)
    def getTriggers: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.Trigger.ReadOnly
    ]] = AwsError.unwrapOptionField("triggers", triggers)
    def getQueues: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.Queue.ReadOnly
    ]] = AwsError.unwrapOptionField("queues", queues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentResourceDescription
  ) extends zio.aws.elasticbeanstalk.model.EnvironmentResourceDescription.ReadOnly {
    override val environmentName: Optional[EnvironmentName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
        )
    override val autoScalingGroups: Optional[
      List[zio.aws.elasticbeanstalk.model.AutoScalingGroup.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.autoScalingGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.AutoScalingGroup.wrap(item)
        }.toList
      )
    override val instances
        : Optional[List[zio.aws.elasticbeanstalk.model.Instance.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.Instance.wrap(item)
          }.toList
        )
    override val launchConfigurations: Optional[
      List[zio.aws.elasticbeanstalk.model.LaunchConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.launchConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.LaunchConfiguration.wrap(item)
        }.toList
      )
    override val launchTemplates: Optional[
      List[zio.aws.elasticbeanstalk.model.LaunchTemplate.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.launchTemplates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.LaunchTemplate.wrap(item)
        }.toList
      )
    override val loadBalancers
        : Optional[List[zio.aws.elasticbeanstalk.model.LoadBalancer.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.LoadBalancer.wrap(item)
          }.toList
        )
    override val triggers
        : Optional[List[zio.aws.elasticbeanstalk.model.Trigger.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.triggers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.Trigger.wrap(item)
          }.toList
        )
    override val queues
        : Optional[List[zio.aws.elasticbeanstalk.model.Queue.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.Queue.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentResourceDescription
  ): zio.aws.elasticbeanstalk.model.EnvironmentResourceDescription.ReadOnly =
    new Wrapper(impl)
}
