package zio.aws.elasticbeanstalk.model
import zio.aws.elasticbeanstalk.model.primitives.{
  PlatformName,
  BranchOrder,
  SupportedTier,
  PlatformBranchLifecycleState,
  BranchName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class PlatformBranchSummary(
    platformName: Optional[PlatformName] = Optional.Absent,
    branchName: Optional[BranchName] = Optional.Absent,
    lifecycleState: Optional[PlatformBranchLifecycleState] = Optional.Absent,
    branchOrder: Optional[BranchOrder] = Optional.Absent,
    supportedTierList: Optional[Iterable[SupportedTier]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.PlatformBranchSummary = {
    import PlatformBranchSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.PlatformBranchSummary
      .builder()
      .optionallyWith(
        platformName.map(value => PlatformName.unwrap(value): java.lang.String)
      )(_.platformName)
      .optionallyWith(
        branchName.map(value => BranchName.unwrap(value): java.lang.String)
      )(_.branchName)
      .optionallyWith(
        lifecycleState.map(value =>
          PlatformBranchLifecycleState.unwrap(value): java.lang.String
        )
      )(_.lifecycleState)
      .optionallyWith(
        branchOrder.map(value => BranchOrder.unwrap(value): Integer)
      )(_.branchOrder)
      .optionallyWith(
        supportedTierList.map(value =>
          value.map { item =>
            SupportedTier.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supportedTierList)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.PlatformBranchSummary.ReadOnly =
    zio.aws.elasticbeanstalk.model.PlatformBranchSummary.wrap(buildAwsValue())
}
object PlatformBranchSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.PlatformBranchSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.PlatformBranchSummary =
      zio.aws.elasticbeanstalk.model.PlatformBranchSummary(
        platformName.map(value => value),
        branchName.map(value => value),
        lifecycleState.map(value => value),
        branchOrder.map(value => value),
        supportedTierList.map(value => value)
      )
    def platformName: Optional[PlatformName]
    def branchName: Optional[BranchName]
    def lifecycleState: Optional[PlatformBranchLifecycleState]
    def branchOrder: Optional[BranchOrder]
    def supportedTierList: Optional[List[SupportedTier]]
    def getPlatformName: ZIO[Any, AwsError, PlatformName] =
      AwsError.unwrapOptionField("platformName", platformName)
    def getBranchName: ZIO[Any, AwsError, BranchName] =
      AwsError.unwrapOptionField("branchName", branchName)
    def getLifecycleState: ZIO[Any, AwsError, PlatformBranchLifecycleState] =
      AwsError.unwrapOptionField("lifecycleState", lifecycleState)
    def getBranchOrder: ZIO[Any, AwsError, BranchOrder] =
      AwsError.unwrapOptionField("branchOrder", branchOrder)
    def getSupportedTierList: ZIO[Any, AwsError, List[SupportedTier]] =
      AwsError.unwrapOptionField("supportedTierList", supportedTierList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.PlatformBranchSummary
  ) extends zio.aws.elasticbeanstalk.model.PlatformBranchSummary.ReadOnly {
    override val platformName: Optional[PlatformName] = zio.aws.core.internal
      .optionalFromNullable(impl.platformName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformName(value)
      )
    override val branchName: Optional[BranchName] = zio.aws.core.internal
      .optionalFromNullable(impl.branchName())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.BranchName(value))
    override val lifecycleState: Optional[PlatformBranchLifecycleState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycleState())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives
            .PlatformBranchLifecycleState(value)
        )
    override val branchOrder: Optional[BranchOrder] = zio.aws.core.internal
      .optionalFromNullable(impl.branchOrder())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.BranchOrder(value)
      )
    override val supportedTierList: Optional[List[SupportedTier]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedTierList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.primitives.SupportedTier(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.PlatformBranchSummary
  ): zio.aws.elasticbeanstalk.model.PlatformBranchSummary.ReadOnly =
    new Wrapper(impl)
}
