package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elasticbeanstalk.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceArn: ResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.ListTagsForResourceRequest =
      zio.aws.elasticbeanstalk.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: ResourceArn
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ListTagsForResourceRequest
  ) extends zio.aws.elasticbeanstalk.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.elasticbeanstalk.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ListTagsForResourceRequest
  ): zio.aws.elasticbeanstalk.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
