package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.{
  Description,
  VersionLabel,
  ApplicationName
}
import scala.jdk.CollectionConverters._
final case class UpdateApplicationVersionRequest(
    applicationName: ApplicationName,
    versionLabel: VersionLabel,
    description: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationVersionRequest = {
    import UpdateApplicationVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationVersionRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .versionLabel(VersionLabel.unwrap(versionLabel): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.UpdateApplicationVersionRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.UpdateApplicationVersionRequest
      .wrap(buildAwsValue())
}
object UpdateApplicationVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.UpdateApplicationVersionRequest =
      zio.aws.elasticbeanstalk.model.UpdateApplicationVersionRequest(
        applicationName,
        versionLabel,
        description.map(value => value)
      )
    def applicationName: ApplicationName
    def versionLabel: VersionLabel
    def description: Optional[Description]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getVersionLabel: ZIO[Any, Nothing, VersionLabel] =
      ZIO.succeed(versionLabel)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationVersionRequest
  ) extends zio.aws.elasticbeanstalk.model.UpdateApplicationVersionRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.elasticbeanstalk.model.primitives
        .ApplicationName(impl.applicationName())
    override val versionLabel: VersionLabel =
      zio.aws.elasticbeanstalk.model.primitives
        .VersionLabel(impl.versionLabel())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.Description(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationVersionRequest
  ): zio.aws.elasticbeanstalk.model.UpdateApplicationVersionRequest.ReadOnly =
    new Wrapper(impl)
}
