package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EnvironmentResourcesDescription(
    loadBalancer: Optional[
      zio.aws.elasticbeanstalk.model.LoadBalancerDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentResourcesDescription = {
    import EnvironmentResourcesDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentResourcesDescription
      .builder()
      .optionallyWith(loadBalancer.map(value => value.buildAwsValue()))(
        _.loadBalancer
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.EnvironmentResourcesDescription.ReadOnly =
    zio.aws.elasticbeanstalk.model.EnvironmentResourcesDescription
      .wrap(buildAwsValue())
}
object EnvironmentResourcesDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentResourcesDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.EnvironmentResourcesDescription =
      zio.aws.elasticbeanstalk.model.EnvironmentResourcesDescription(
        loadBalancer.map(value => value.asEditable)
      )
    def loadBalancer: Optional[
      zio.aws.elasticbeanstalk.model.LoadBalancerDescription.ReadOnly
    ]
    def getLoadBalancer: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.LoadBalancerDescription.ReadOnly
    ] = AwsError.unwrapOptionField("loadBalancer", loadBalancer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentResourcesDescription
  ) extends zio.aws.elasticbeanstalk.model.EnvironmentResourcesDescription.ReadOnly {
    override val loadBalancer: Optional[
      zio.aws.elasticbeanstalk.model.LoadBalancerDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.loadBalancer())
      .map(value =>
        zio.aws.elasticbeanstalk.model.LoadBalancerDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentResourcesDescription
  ): zio.aws.elasticbeanstalk.model.EnvironmentResourcesDescription.ReadOnly =
    new Wrapper(impl)
}
