package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.{
  PlatformFilterValue,
  PlatformFilterOperator,
  PlatformFilterType
}
import scala.jdk.CollectionConverters._
final case class PlatformFilter(
    `type`: Optional[PlatformFilterType] = Optional.Absent,
    operator: Optional[PlatformFilterOperator] = Optional.Absent,
    values: Optional[Iterable[PlatformFilterValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFilter = {
    import PlatformFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFilter
      .builder()
      .optionallyWith(
        `type`.map(value => PlatformFilterType.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        operator.map(value =>
          PlatformFilterOperator.unwrap(value): java.lang.String
        )
      )(_.operator)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            PlatformFilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.PlatformFilter.ReadOnly =
    zio.aws.elasticbeanstalk.model.PlatformFilter.wrap(buildAwsValue())
}
object PlatformFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.PlatformFilter =
      zio.aws.elasticbeanstalk.model.PlatformFilter(
        `type`.map(value => value),
        operator.map(value => value),
        values.map(value => value)
      )
    def `type`: Optional[PlatformFilterType]
    def operator: Optional[PlatformFilterOperator]
    def values: Optional[List[PlatformFilterValue]]
    def getType: ZIO[Any, AwsError, PlatformFilterType] =
      AwsError.unwrapOptionField("type", `type`)
    def getOperator: ZIO[Any, AwsError, PlatformFilterOperator] =
      AwsError.unwrapOptionField("operator", operator)
    def getValues: ZIO[Any, AwsError, List[PlatformFilterValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFilter
  ) extends zio.aws.elasticbeanstalk.model.PlatformFilter.ReadOnly {
    override val `type`: Optional[PlatformFilterType] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformFilterType(value)
      )
    override val operator: Optional[PlatformFilterOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operator())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives
            .PlatformFilterOperator(value)
        )
    override val values: Optional[List[PlatformFilterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.values())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.primitives.PlatformFilterValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFilter
  ): zio.aws.elasticbeanstalk.model.PlatformFilter.ReadOnly = new Wrapper(impl)
}
