package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribePlatformVersionResponse(
    platformDescription: Optional[
      zio.aws.elasticbeanstalk.model.PlatformDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribePlatformVersionResponse = {
    import DescribePlatformVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribePlatformVersionResponse
      .builder()
      .optionallyWith(platformDescription.map(value => value.buildAwsValue()))(
        _.platformDescription
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribePlatformVersionResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribePlatformVersionResponse
      .wrap(buildAwsValue())
}
object DescribePlatformVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribePlatformVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DescribePlatformVersionResponse =
      zio.aws.elasticbeanstalk.model.DescribePlatformVersionResponse(
        platformDescription.map(value => value.asEditable)
      )
    def platformDescription
        : Optional[zio.aws.elasticbeanstalk.model.PlatformDescription.ReadOnly]
    def getPlatformDescription: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.PlatformDescription.ReadOnly
    ] = AwsError.unwrapOptionField("platformDescription", platformDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribePlatformVersionResponse
  ) extends zio.aws.elasticbeanstalk.model.DescribePlatformVersionResponse.ReadOnly {
    override val platformDescription: Optional[
      zio.aws.elasticbeanstalk.model.PlatformDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.platformDescription())
      .map(value =>
        zio.aws.elasticbeanstalk.model.PlatformDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribePlatformVersionResponse
  ): zio.aws.elasticbeanstalk.model.DescribePlatformVersionResponse.ReadOnly =
    new Wrapper(impl)
}
