package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class LaunchConfiguration(
    name: Optional[ResourceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.LaunchConfiguration = {
    import LaunchConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.LaunchConfiguration
      .builder()
      .optionallyWith(
        name.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.LaunchConfiguration.ReadOnly =
    zio.aws.elasticbeanstalk.model.LaunchConfiguration.wrap(buildAwsValue())
}
object LaunchConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.LaunchConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.LaunchConfiguration =
      zio.aws.elasticbeanstalk.model
        .LaunchConfiguration(name.map(value => value))
    def name: Optional[ResourceId]
    def getName: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.LaunchConfiguration
  ) extends zio.aws.elasticbeanstalk.model.LaunchConfiguration.ReadOnly {
    override val name: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.ResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.LaunchConfiguration
  ): zio.aws.elasticbeanstalk.model.LaunchConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
