package zio.aws.elasticbeanstalk.model
import zio.aws.elasticbeanstalk.model.primitives.{RequestCount, NullableInteger}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ApplicationMetrics(
    duration: Optional[NullableInteger] = Optional.Absent,
    requestCount: Optional[RequestCount] = Optional.Absent,
    statusCodes: Optional[zio.aws.elasticbeanstalk.model.StatusCodes] =
      Optional.Absent,
    latency: Optional[zio.aws.elasticbeanstalk.model.Latency] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationMetrics = {
    import ApplicationMetrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationMetrics
      .builder()
      .optionallyWith(duration.map(value => value: Integer))(_.duration)
      .optionallyWith(
        requestCount.map(value => RequestCount.unwrap(value): Integer)
      )(_.requestCount)
      .optionallyWith(statusCodes.map(value => value.buildAwsValue()))(
        _.statusCodes
      )
      .optionallyWith(latency.map(value => value.buildAwsValue()))(_.latency)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.ApplicationMetrics.ReadOnly =
    zio.aws.elasticbeanstalk.model.ApplicationMetrics.wrap(buildAwsValue())
}
object ApplicationMetrics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationMetrics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.ApplicationMetrics =
      zio.aws.elasticbeanstalk.model.ApplicationMetrics(
        duration.map(value => value),
        requestCount.map(value => value),
        statusCodes.map(value => value.asEditable),
        latency.map(value => value.asEditable)
      )
    def duration: Optional[NullableInteger]
    def requestCount: Optional[RequestCount]
    def statusCodes
        : Optional[zio.aws.elasticbeanstalk.model.StatusCodes.ReadOnly]
    def latency: Optional[zio.aws.elasticbeanstalk.model.Latency.ReadOnly]
    def getDuration: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("duration", duration)
    def getRequestCount: ZIO[Any, AwsError, RequestCount] =
      AwsError.unwrapOptionField("requestCount", requestCount)
    def getStatusCodes: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.StatusCodes.ReadOnly
    ] = AwsError.unwrapOptionField("statusCodes", statusCodes)
    def getLatency
        : ZIO[Any, AwsError, zio.aws.elasticbeanstalk.model.Latency.ReadOnly] =
      AwsError.unwrapOptionField("latency", latency)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationMetrics
  ) extends zio.aws.elasticbeanstalk.model.ApplicationMetrics.ReadOnly {
    override val duration: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: NullableInteger)
    override val requestCount: Optional[RequestCount] = zio.aws.core.internal
      .optionalFromNullable(impl.requestCount())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.RequestCount(value)
      )
    override val statusCodes
        : Optional[zio.aws.elasticbeanstalk.model.StatusCodes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusCodes())
        .map(value => zio.aws.elasticbeanstalk.model.StatusCodes.wrap(value))
    override val latency
        : Optional[zio.aws.elasticbeanstalk.model.Latency.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latency())
        .map(value => zio.aws.elasticbeanstalk.model.Latency.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationMetrics
  ): zio.aws.elasticbeanstalk.model.ApplicationMetrics.ReadOnly = new Wrapper(
    impl
  )
}
