package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.{
  EnvironmentName,
  ConfigurationTemplateName,
  ApplicationName
}
import scala.jdk.CollectionConverters._
final case class ValidateConfigurationSettingsRequest(
    applicationName: ApplicationName,
    templateName: Optional[ConfigurationTemplateName] = Optional.Absent,
    environmentName: Optional[EnvironmentName] = Optional.Absent,
    optionSettings: Iterable[
      zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest = {
    import ValidateConfigurationSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(
        templateName.map(value =>
          ConfigurationTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionSettings(optionSettings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ValidateConfigurationSettingsRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.ValidateConfigurationSettingsRequest
      .wrap(buildAwsValue())
}
object ValidateConfigurationSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.ValidateConfigurationSettingsRequest =
      zio.aws.elasticbeanstalk.model.ValidateConfigurationSettingsRequest(
        applicationName,
        templateName.map(value => value),
        environmentName.map(value => value),
        optionSettings.map { item =>
          item.asEditable
        }
      )
    def applicationName: ApplicationName
    def templateName: Optional[ConfigurationTemplateName]
    def environmentName: Optional[EnvironmentName]
    def optionSettings: List[
      zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly
    ]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getTemplateName: ZIO[Any, AwsError, ConfigurationTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getOptionSettings: ZIO[Any, Nothing, List[
      zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly
    ]] = ZIO.succeed(optionSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest
  ) extends zio.aws.elasticbeanstalk.model.ValidateConfigurationSettingsRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.elasticbeanstalk.model.primitives
        .ApplicationName(impl.applicationName())
    override val templateName: Optional[ConfigurationTemplateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives
            .ConfigurationTemplateName(value)
        )
    override val environmentName: Optional[EnvironmentName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
        )
    override val optionSettings: List[
      zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly
    ] = impl
      .optionSettings()
      .asScala
      .map { item =>
        zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest
  ): zio.aws.elasticbeanstalk.model.ValidateConfigurationSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
