package zio.aws.elasticbeanstalk.model
import zio.aws.elasticbeanstalk.model.primitives.{
  ConfigurationTemplateName,
  ApplicationName,
  EnvironmentName,
  EventDate,
  EventMessage,
  VersionLabel,
  PlatformArn,
  RequestId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class EventDescription(
    eventDate: Optional[EventDate] = Optional.Absent,
    message: Optional[EventMessage] = Optional.Absent,
    applicationName: Optional[ApplicationName] = Optional.Absent,
    versionLabel: Optional[VersionLabel] = Optional.Absent,
    templateName: Optional[ConfigurationTemplateName] = Optional.Absent,
    environmentName: Optional[EnvironmentName] = Optional.Absent,
    platformArn: Optional[PlatformArn] = Optional.Absent,
    requestId: Optional[RequestId] = Optional.Absent,
    severity: Optional[zio.aws.elasticbeanstalk.model.EventSeverity] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.EventDescription = {
    import EventDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.EventDescription
      .builder()
      .optionallyWith(eventDate.map(value => EventDate.unwrap(value): Instant))(
        _.eventDate
      )
      .optionallyWith(
        message.map(value => EventMessage.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        versionLabel.map(value => VersionLabel.unwrap(value): java.lang.String)
      )(_.versionLabel)
      .optionallyWith(
        templateName.map(value =>
          ConfigurationTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(
        platformArn.map(value => PlatformArn.unwrap(value): java.lang.String)
      )(_.platformArn)
      .optionallyWith(
        requestId.map(value => RequestId.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(severity.map(value => value.unwrap))(_.severity)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.EventDescription.ReadOnly =
    zio.aws.elasticbeanstalk.model.EventDescription.wrap(buildAwsValue())
}
object EventDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.EventDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.EventDescription =
      zio.aws.elasticbeanstalk.model.EventDescription(
        eventDate.map(value => value),
        message.map(value => value),
        applicationName.map(value => value),
        versionLabel.map(value => value),
        templateName.map(value => value),
        environmentName.map(value => value),
        platformArn.map(value => value),
        requestId.map(value => value),
        severity.map(value => value)
      )
    def eventDate: Optional[EventDate]
    def message: Optional[EventMessage]
    def applicationName: Optional[ApplicationName]
    def versionLabel: Optional[VersionLabel]
    def templateName: Optional[ConfigurationTemplateName]
    def environmentName: Optional[EnvironmentName]
    def platformArn: Optional[PlatformArn]
    def requestId: Optional[RequestId]
    def severity: Optional[zio.aws.elasticbeanstalk.model.EventSeverity]
    def getEventDate: ZIO[Any, AwsError, EventDate] =
      AwsError.unwrapOptionField("eventDate", eventDate)
    def getMessage: ZIO[Any, AwsError, EventMessage] =
      AwsError.unwrapOptionField("message", message)
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getVersionLabel: ZIO[Any, AwsError, VersionLabel] =
      AwsError.unwrapOptionField("versionLabel", versionLabel)
    def getTemplateName: ZIO[Any, AwsError, ConfigurationTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getPlatformArn: ZIO[Any, AwsError, PlatformArn] =
      AwsError.unwrapOptionField("platformArn", platformArn)
    def getRequestId: ZIO[Any, AwsError, RequestId] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getSeverity
        : ZIO[Any, AwsError, zio.aws.elasticbeanstalk.model.EventSeverity] =
      AwsError.unwrapOptionField("severity", severity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.EventDescription
  ) extends zio.aws.elasticbeanstalk.model.EventDescription.ReadOnly {
    override val eventDate: Optional[EventDate] = zio.aws.core.internal
      .optionalFromNullable(impl.eventDate())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.EventDate(value))
    override val message: Optional[EventMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EventMessage(value)
      )
    override val applicationName: Optional[ApplicationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.ApplicationName(value)
        )
    override val versionLabel: Optional[VersionLabel] = zio.aws.core.internal
      .optionalFromNullable(impl.versionLabel())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.VersionLabel(value)
      )
    override val templateName: Optional[ConfigurationTemplateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives
            .ConfigurationTemplateName(value)
        )
    override val environmentName: Optional[EnvironmentName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
        )
    override val platformArn: Optional[PlatformArn] = zio.aws.core.internal
      .optionalFromNullable(impl.platformArn())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformArn(value)
      )
    override val requestId: Optional[RequestId] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.RequestId(value))
    override val severity
        : Optional[zio.aws.elasticbeanstalk.model.EventSeverity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severity())
        .map(value => zio.aws.elasticbeanstalk.model.EventSeverity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.EventDescription
  ): zio.aws.elasticbeanstalk.model.EventDescription.ReadOnly = new Wrapper(
    impl
  )
}
